package awt02farbe;

import java.awt.*;
import java.awt.event.*;

public class MeinFenster extends Frame
{
	public MeinFenster()
	{
		super("MeinFenster");
		this.setSize(300,200);
		this.setLocation(50, 50);
		// Hintergrundfarbe einstellen
		this.setBackground(Color.LIGHT_GRAY);
								
		this.addWindowListener(new WindowAdapter()
		{	public void windowClosing(WindowEvent we)
			{	System.exit(0);		}
		}	);
		
		this.setVisible(true);
	}

	public void paint(Graphics g)
	{
		// Farbkonstanten verwenden
		g.setColor(Color.red);
		g.fillOval(100, 40, 20, 20);
		g.setColor(Color.green);
		g.fillOval(120, 40, 20, 20);
		g.setColor(Color.blue);
		g.fillOval(140, 40, 20, 20);
		// Systemfarben verwenden
		g.setColor(SystemColor.activeCaption);
		g.fillOval(20, 150, 20, 20);
		
		Color c; int x, y;
		
		for (int i=0; i<256; i=i+4)
		{
			for (int j=0; j<256; j=j+4)
			{
				for (int k=0; k<256; k=k+4)
				{
					x = k/4+i/4+20;
					y = j/4+i/4+40;
					// Eigene RGB-Farben
					c = new Color (i,j,k);
					g.setColor(c);
					g.fillOval(x,y,2,2);
				}
			}
		}
		
		for (int i=0; i<256; i=i+20)
		{
			// RGB-Farbe mit Transparenz
			c = new Color (255,0,100,i);
			g.setColor(c);
			g.fillOval(200, 40+i/2, 40, 15);
		}
	}
}
