package awt04text;

import java.awt.*;
import java.awt.event.*;

public class MeinFenster extends Frame
{
	public MeinFenster()
	{
		super("MeinFenster");
		this.setSize(300,200);
		this.setLocation(50, 50);
			
		this.addWindowListener(new WindowAdapter()
		{	public void windowClosing(WindowEvent we)
			{	System.exit(0);		}
		}	);
		
		this.setVisible(true);
	}
	
	public void paint(Graphics g)
	{
		int x1 = 50, x2 = 130, x3 = 210;
		int y1 = 50;
		
		// Standartausgaben
		String s = "String";
		char[] c = {'C', 'h', 'a', 'r'};
		byte[] b = {66, 121, 116, 101};
		
		g.drawString(s, x1, y1);
		g.drawChars(c, 0, c.length, x2, y1);
		g.drawBytes(b, 0, b.length, x3, y1);
		
		// Standardfonts
		s = "Hallo";		
		String[] name = {"SansSerif", "Serif", "Monospaced"};
		int[] style = {Font.PLAIN, Font.BOLD, Font.ITALIC};
		int size = 20;
		Font[][] font = new Font[3][3];
		
		for (int i=0; i<3; i++)
		{
			int x, y;
			for (int j=0; j<3; j++)
			{
				font[i][j] = new Font(name[i], style[j], size);
				g.setFont(font[i][j]);
				x = i * 60 + 60;
				y = j * 30 + 80;
				g.drawString(s, x, y);
			}	
		}
		
		// FontMetrik & Farbe
		s = "Farbig";
		Font f = new Font ("Serif", Font.BOLD, size);
		int x = 120, y = 180; 

		g.setFont(f);
		FontMetrics fm = g.getFontMetrics();
		int hoehe = fm.getHeight();
		int oberlaenge = fm.getAscent();
		int breite = fm.stringWidth(s);
		
		g.setColor(Color.gray);
		g.fillRect(x, y-oberlaenge, breite, hoehe);
		g.setColor(Color.orange);
		g.drawString(s, x, y);	
	}
}
