package awt07eventKey;
import java.awt.*;
import java.awt.event.*;

// Interface
public class V4 extends Frame implements KeyListener
{
	public V4()
	{
		super("Variante 4");
		this.setSize(250,200);
		this.setLocation(800, 50);
						
		this.addKeyListener(this);
		
		MyWindowListener mwl = new MyWindowListener(true);
		this.addWindowListener(mwl);		
				
		this.setVisible(true);
	}
	
	public void paint(Graphics g)
	{
		g.setColor(Color.GREEN);
		g.fillRect(80, 80, 80, 80);	
	}

	public void keyTyped(KeyEvent e)
	{}

	public void keyPressed(KeyEvent e)
	{
		Graphics g = this.getGraphics();
		g.setColor(Color.RED);
		
		switch (e.getKeyChar())
		{
		case 'k': case 'K':
			g.fillOval(100, 100, 40, 40);
			break;
		case 'q': case 'Q':
			g.fillRect(100, 100, 40, 40);
			break;
		}		
	}

	public void keyReleased(KeyEvent e)
	{
		Graphics g = this.getGraphics();
		g.setColor(Color.GREEN);
		g.fillRect(80, 80, 80, 80);	
	}
}
