package awt14layoutGridBag;

import java.awt.*;
import java.awt.event.*;

public class MeinFenster extends Frame
{
	private static final long serialVersionUID = 1L;

	public MeinFenster()
	{
		super("MeinFenster");

		GridBagLayout gbl = new GridBagLayout();

		this.addComponent(gbl, new Button("Button 1"), 0, 0, 2, 1);
		this.addComponent(gbl, new Button("Button 2"), 0, 1, 1, 1);
		this.addComponent(gbl, new Button("Button 3"), 0, 2, 1, 1);
		this.addComponent(gbl, new Button("Button 4"), 1, 1, 1, 2);

		this.setLayout(gbl);

		this.setSize(300, 150);
		this.setLocation(50, 50);

		this.addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent we)
			{
				System.exit(0);
			}
		});

		this.setVisible(true);
	}

	void addComponent(GridBagLayout gbl, Component c, int x, int y, int width,
			int height)
	{
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.fill = GridBagConstraints.BOTH;
		gbc.gridx = x;
		gbc.gridy = y;
		gbc.gridwidth = width;
		gbc.gridheight = height;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbl.setConstraints(c, gbc);
		this.add(c);
	}
}
