package buecherei;

import java.awt.*;
import java.awt.event.*;
import java.math.BigInteger;
import java.text.*;
import java.util.*;
import javax.swing.*;

public class AnwendungsfallAusleihenVC implements _StringDaten, ActionListener
{
	private JFrame frame;
	
// Das Model bestehend aus Kunde und Buch
	private Kunde 		kunde 			= new Kunde();
	private Buch 		buch 			= new Buch();
	
// Schalter und Label (Werte aus TextData)	
	private JButton		buttonOk		= new JButton(BUTTON_OK);
	private JButton		buttonAbbrechen = new JButton(BUTTON_ABBRECHEN);
	private JButton		buttonKunde		= new JButton(BUTTON_KUNDE);
	private JButton		buttonBuch		= new JButton(BUTTON_BUCH);	
	private JLabel		labelFrist 		= new JLabel(LABEL_FRIST);		
	private JTextArea	areaKunde		= new JTextArea(kunde.getKunde(), 10, 30);	
	private JTextArea	areaBuch 		= new JTextArea(buch.getBuch(), 10, 30);
	
// Eingabefelder
	private JFormattedTextField		frist;

	public AnwendungsfallAusleihenVC()
	{
		frame = new JFrame(TITEL_AUSLEIHE);
				
	// Formatierung fr Textfeld festlegen
		DateFormat format = DateFormat.getDateInstance();
		frist = new JFormattedTextField(format);
		
	// TextArea nur als Textanzeige gedacht
		areaKunde.setEditable(false);
		areaBuch.setEditable(false);
				
	// Oberer Bereich Eingabe der Ausleihfrist
		Container obenPane = new Container();
		obenPane.setLayout(new GridLayout(1,2));
		obenPane.add(labelFrist);
		obenPane.add(frist);
				
	// Unterer Bereich mit Schalter
		Container untenPane = new Container();
		untenPane.setLayout(new FlowLayout());
		untenPane.add(buttonKunde);
		untenPane.add(buttonBuch);
		untenPane.add(buttonOk);
		untenPane.add(buttonAbbrechen);
		
	// Fensterlayout aus Einzelkomponenten zusammenbauen
		Container contentPane = frame.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.PAGE_START, obenPane);
		contentPane.add(BorderLayout.LINE_START, areaKunde);
		contentPane.add(BorderLayout.LINE_END, areaBuch);
		contentPane.add(BorderLayout.PAGE_END, untenPane);
		
	//Listener registrieren
		buttonKunde.addActionListener(this);
		buttonBuch.addActionListener(this);
		buttonOk.addActionListener(this);
		buttonAbbrechen.addActionListener(this);
		
	// Sonstige Fenstereinstellungen
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(700, 400);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);		
	}

	@Override
	public void actionPerformed(ActionEvent e)
	{
		
	// Kunde-Schalter
		if(e.getSource() == buttonKunde)
		{	// Kunde identifizieren - Filterdaten setzen
			DialogKundeAuswahlViewController vkt = new DialogKundeAuswahlViewController(frame, kunde);
			vkt.setVisible(true);
			areaKunde.setText(kunde.getKunde());
		}
	// Buch-Schalter
		if(e.getSource() == buttonBuch)
		{	// Buch identifizieren - Filterdaten setzen
			DialogBuchAuswahlViewController vbt = new DialogBuchAuswahlViewController(frame, buch);
			vbt.setVisible(true);
			areaBuch.setText(buch.getBuch());
		}
	// OK Schalter (Ausleihe)
		if(e.getSource() == buttonOk)
		{	
		// ID-Buch bestimmen
			BigInteger 	idBuch 	= buch.getIdBuch();
		// ID-Kunde bestimmen
			BigInteger 	idKunde = kunde.getIdKunde();
		// Ausleihfrist bestimmen
			SimpleDateFormat 	format = new SimpleDateFormat("dd.MM.yyyy", Locale.GERMAN);
			Date frist = null;
			try		{	frist = format.parse(this.frist.getText()); 	}
			catch	(ParseException e1)	{	frist = null;	}

		// Kontrolle und speichern
			if (idBuch == null || idKunde == null || frist == null)
			{	// NICHT alle bentigten Werte angegeben
				JOptionPane.showMessageDialog(null,  TEXT_WARNUNG, TITEL_WARNUNG,  JOptionPane.WARNING_MESSAGE);
			}
			else
			{	// ALLE bentigten Werte vorhanden
				buch.ausleihe(idKunde, frist);
				JOptionPane.showMessageDialog(null,  TEXT_MELDUNG, TITEL_MELDUNG,  JOptionPane.INFORMATION_MESSAGE);
				frame.setVisible(false);
				frame.dispose();
			}
		}
	// Abbrechen-Schalter
		if(e.getSource() == buttonAbbrechen)
		{	
			frame.setVisible(false);
			frame.dispose();
		}
	}
}
