package buecherei;

import java.math.BigInteger;
import java.util.Date;

public class Buch implements _Debug, _DatenbankDaten
{
	private BigInteger	idBuch;
	private String 		isbn;
	private String 		titel;
	private String 		vorname;	//Autor des Buches
	private String 		nachname; 	//Autor des Buches
	
	//Referenz auf den Kunden der das Buch ausleiht
	private Long	 	idKunde;	// ausleihender Kunde
	private Date 		frist;		// Datum der Rckgabe
	
	public Buch()					// legt leeres Buchobjekt an
	{
		super();
		this.reset();
	}
	
	public void bestimmen (BigInteger idBuch)
	{
		String query = DatenbankQuery.makeQuery(BUCH, idBuch);
		DatenbankController	db = new DatenbankController();
		Object [] werte = db.dbGetRowValues(query, 0, spaltenNamen[BUCH].length);
		this.idBuch 	= (BigInteger)	werte[0];
		this.isbn		= (String) 		werte[1];
		this.titel		= (String)		werte[2];
		this.vorname	= (String)		werte[3];
		this.nachname	= (String)		werte[4];
		this.idKunde	= (Long) 		werte[5];		
		this.frist		= (Date)		werte[6];			
	}
	
	public void ausleihe(BigInteger idKunde, Date frist)
	{
	// Werte einstellen
		this.frist = frist;
		this.idKunde = idKunde.longValue();
	// Daten in Datenbank speichern
		String[] merkmale = { spaltenNamen[BUCH][5], spaltenNamen[BUCH][6]}; 
		Object[] werte = {idKunde, frist};
	
		String sql = DatenbankQuery.makeUpdate(BUCH, idBuch, merkmale, werte);
		DatenbankController	db = new DatenbankController();
		db.dbUpdate(sql);
	}
		
	public BigInteger getIdBuch ()
	{
		return this.idBuch;
	}
	
	public void setIsbn(String isbn)
	{
		this.isbn = isbn;
	}
	
	public String getIsbn()
	{
		return isbn;
	}
	
	public void setTitel(String titel)
	{
		this.titel = titel;
	}
	
	public String getTitel()
	{
		return this.titel;
	}
	
	public void setVorname(String vorname)
	{
		this.vorname = vorname;
	}
	
	public String getVorname()
	{
		return this.vorname;
	}
	
	public void setNachname(String nachname)
	{
		this.nachname = nachname;
	}
	
	public String getNachname()
	{
		return this.nachname;
	}	
	
	public void reset()
	{
		this.idBuch		= null;
		this.isbn		= null;
		this.titel		= null;		
		this.vorname	= null;
		this.nachname	= null;
		this.idKunde	= null;	
		this.frist		= null;
	}
	
	public Object[] getWerte()
	{
		Object[] s = {
				idBuch,
				isbn, 
				titel, 
				vorname,
				nachname, 
				idKunde,
				frist}; 
		return s;
	}
	
	public String getBuch()
	{
		String s = 	"_____ BUCH _____\n";
		if (this.idBuch!=null)
		{			
			s = s 	+ 	"ID_Buch: \t"	+ this.idBuch 	+ "\n"
					+ 	"ISBN: \t" 		+ this.isbn 	+ "\n"
					+ 	"Titel: \t" 	+ this.titel 	+ "\n"
					+ 	"Vorname: \t" 	+ this.vorname  + " (Autor)\n"
					+ 	"Nachname: \t" 	+ this.nachname + " (Autor)\n"
					+ 	"ID-Kunde: \t" 	+ this.idKunde	+ " (Ausleiher)\n"
					+ 	"Frist: \t" 	+ this.frist	+ " (Zurck)\n";
		}
		return s;
	}	
	
	public void showBuch()
	{
		if (TESTMODUS)
		{
			System.out.println(this.getBuch());
		}
	}
}
