package buecherei;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import javax.swing.JOptionPane;

/**
 * 
 * @author vjanssen
 *
 * Bietet Funktionen fr den Zugriff auf die konkrete Datenbank
 * Entkoppelt das Projekt vom Datenbankserver MariaSql
 * 
 */
public class DatenbankController implements _DatenbankDaten, _Debug, _StringDaten
{
	// Datenbank Verbindungsdaten
	private static Connection 	con = null; // Vebindungsreferenz
	private Statement 			stm = null; // DB-Abfrage-Statement
	
	//Zugriffsoptimierung
	private ResultSet 			rs 	= null; // ResultSet speichern
	private String 				sql = "";	// SQL-Befehl speichern
	
// Konstruktor
	
	/**
	 * Datenbankverbindung aufbauen
	 */
	public DatenbankController()
	{
		try
		{
			Class.forName("com.mysql.jdbc.Driver");

			String s = "jdbc:mysql://" + HOST + ":" + PORT + "/" + DB + "?"	+ "user=" + USER + "&" + "password=" + PASSWD;

			con = DriverManager.getConnection(s);
			stm = con.createStatement();
		} 
		catch (ClassNotFoundException e)
		{
			JOptionPane.showMessageDialog(null,  ERROR_DB_TREIBER, TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
		} 
		catch (SQLException e)
		{
			JOptionPane.showMessageDialog(null,  ERROR_DB_SERVER, TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
		}
		catch (Exception e)
		{
			JOptionPane.showMessageDialog(null,  e.getMessage(), TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
		}
	}
	
//Objektmethoden	
	/**
	 * Datenbank-Abfrage ausfhren und Cursor auf Anfang Positionieen
	 * DB-Zugriff allerdings nur wenn sich die SQL-Anfrage gendert hat!
	 * @param sql Datenbankabfrage
	 * @return ResultSet Abfrageergebnis
	 */
	public void dbQuery(String sql)
	{
		if (!this.sql.equals(sql))	
		{ // resultSet muss aktualisiert werden 
			this.sql = sql;
			try
			{
				if(TESTMODUS) System.out.println("DatenbankController->dbQuery: Datenbankzugriff erfolgt!");
				rs = stm.executeQuery(sql);
			} 
			catch (Exception e)
			{
				JOptionPane.showMessageDialog(null,  e.getMessage(), TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
			}
		}
	}
	
	/**
	 * Datenbank-Update ausfhren
	 * @param sql Update-Anweisung
	 * @return boolean true=OK / false=fehler
	 */
	public boolean dbUpdate(String sql)
	{
		try
		{
			this.sql = sql;
			stm.executeUpdate(sql);
			return true;
		} 
		catch (SQLException e)
		{
			JOptionPane.showMessageDialog(null,  e.getMessage(), TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
			return false;
		}
	}

	/**
	 * Zelleninhalt eines Abfrageergebnisses bestimmen
	 * @param sql Datenbankabfrage
	 * @param rowIndex Zeile
	 * @param columnIndex Spalte
	 * @return Object Zelleninhalt
	 */
	public Object dbGetValueAt(String sql, int rowIndex, int columnIndex)
	{
		try
		{
			dbQuery(sql);
			rs.beforeFirst();
			for (int i = 0; i <= rowIndex; i++) rs.next();
			return rs.getObject(columnIndex + 1);
		}
		catch (Exception e)
		{
			JOptionPane.showMessageDialog(null,  e.getMessage(), TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
			return null;
		}
	}
	
	/**
	 * Zeileninhalt als Objektarray zurckgeben
	 * @param sql Datenbankabfrage
	 * @param rowIndex Zeile
	 * @param columnAnzah Anzahl der Spalten
	 * @return Array vom Typ Object mit den Zeilenwerten
	 */
	public Object[] dbGetRowValues(String sql, int rowIndex, int columnAnzahl)
	{
		Object[] werte = new Object[columnAnzahl];
		
		try
		{
			dbQuery(sql);
			rs.beforeFirst();
			for (int i = 0; i <= rowIndex; i++) rs.next();
			for (int i = 0; i < columnAnzahl; i++)
				werte[i] = rs.getObject(i+1);
		}
		catch (SQLException e)
		{
			JOptionPane.showMessageDialog(null,  e.getMessage(), TITEL_FEHLER,  JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		return werte;
	}
}
