package buecherei;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Locale;

/**
 * 
 * @author vjanssen
 *
 * Bietet statische Hilfskunktionen an zum Zusammenbauen der bentigten SQL-Abfragen
 * Entkoppelt das Projekt von der Datenbankabfragesprache SQL
 * 
 */
public class DatenbankQuery implements _DatenbankDaten, _Debug
{
	public static enum AbfrageTyp
	{
		FILTER,		// Liefert nur gefilterte Datenstze 
		ANZAHL,		// Liefert die Anzahl an Datenstzen einer Tabelle 
		ID,			// Liefert nur die ID-Werte einer Tabelle
		/*
		 * Weitere Abfragetypen mit eigenen Methoden
		 * UPDATE		ndert Datensatz (makeUpdate())
		 * DATENSATZ	Liefert die Werte eines Datensatzs bei gegebenem ID-Wert 
		 */
	}

	
	/**
	 * Java-Datentypen an Datenbank anpassen
	 * Statische Hilfsfunktion
	 */
	public static Object typAnpassen(Object wert)
	{
		
		if (wert.getClass().getSimpleName().equals("Date"))
		{	// Datumsangaben anpassen
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
			return format.format(wert);			
		}
		else
		{	// boolsche Werte fr Datenbank in Integer umwandeln
			if (wert.toString().equals("true"))	wert = new Integer(1);
			if (wert.toString().equals("false")) wert = new Integer(0);
		}
		return wert;
	}	
	
	/**
	 * SQL-SELECT-Abfragen (ID-Wert bekannt -> KEINE Filter notwendig)
	 * @param tabellenIndex	Identifikation der Tabelle (DbDaten)
	 * @param idWert		Datensatz-Identifikationsnummer
	 * @return				Zusammengebaute SQL-Anweisung
	 */
	public static String makeQuery(int tabellenIndex, BigInteger idWert)
	{
		// SQL-Zusammenbauen SELECT und FROM
		String tabelle 	= tabellenNamen[tabellenIndex];
		String idName	= spaltenNamen[tabellenIndex][0];
		
		String sql = "SELECT * FROM `" + tabelle + "` WHERE `" + idName + "` = '" + idWert + "';";
		
		if (TESTMODUS) System.out.println("QueryControll->makeQuery(1): " + sql);			
		return sql;
	}
	
	/**
	 * SQL-SELECT-Abfragen (ID-Wert unbekannt -> Filter notwendig)
	 * @param abfrage 		Typ der Abfrage
	 * @param tabellenIndex	Identifikation der Tabelle (DbDaten)
	 * @param merkmale		Filter-Merkmale
	 * @param werte			Werte fr die Filter-Merkmale
	 * @return				Zusammengebaute SQL-Anweisung
	 */
	public static String makeQuery(
			AbfrageTyp abfrage,
			int tabellenIndex,
			String[]merkmale,
			Object[]werte)
	{
	// SQL-Zusammenbauen -> SELECT und FROM Anweisung
		String tabelle = tabellenNamen[tabellenIndex];
		String sql = "SELECT ";
		
		switch (abfrage)
		{
		case FILTER:
			sql = sql + "* FROM `" + tabelle +"` ";
			break;
		case ANZAHL:
			sql = sql + "COUNT(*) FROM `" + tabelle + "` ";
			break;
		case ID:
			sql = sql + " `"  + spaltenNamen[tabellenIndex][0] + "` FROM `" + tabelle + "` ";
			break;
		default:
			return "";			
		}
		
	// SQL-Zusammenbauen -> WHERE Bedingungen (Filterung)
		boolean anfang = true;
		for(int i=0; i<merkmale.length; i++)
		{
			if (werte[i]!=null)
			{
				if (anfang)
				{
					sql = sql + "WHERE";
					anfang = false;
				}
				else
				{
					sql = sql + "AND";
				}
				sql = sql + " `" + merkmale[i] + "` LIKE('" + werte[i] + "')";
			}
		}
		sql = sql + ";";
		
	// SQL-Kontollausgabe wenn Testmodus Aktiv
		if (TESTMODUS) System.out.println("QueryControll->makeQuery(2): " + sql);		
		return sql;
	}
	
	/**
	 * SQL-UPDATE-Abfragen (ID-Wert bekannt -> KEIN Filter notwendig)
	 * @param abfrage 		Typ der Abfrage
	 * @param tabellenIndex	Identifikation der Tabelle (DbDaten)
	 * @param idWert		Datensatz-Identifikationsnummer
	 * @param merkmale		Update-Merkmale
	 * @param werte			Werte fr die Update-Merkmale	
	 * @return				Zusammengebaute SQL-Anweisung
	 */
	public static String makeUpdate(int tabellenIndex, BigInteger idWert, String[]merkmale, Object[]werte)
	{
		String tabelle 	= tabellenNamen[tabellenIndex];
		String idName	= spaltenNamen[tabellenIndex][0];
		
		String sql = 	"UPDATE `" + tabelle + "` SET";
		for(int i=0; i<merkmale.length; i++)
		{
			werte[i] = typAnpassen(werte[i]);
			if (i != 0) sql = sql + ",";
			sql = sql + " `" + merkmale[i] + "` = '" + werte[i] + "' "; 
		}
		sql = sql + " WHERE `" + idName + "` = '" + idWert + "';";
			
		if (TESTMODUS) System.out.println("QueryControll->makeQuery(3): " + sql);			
		return sql;
	}	
}
