package buecherei;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;

import javax.swing.*;

public class DialogBuchAuswahlViewController extends JDialog implements _DatenbankDaten, _StringDaten, ActionListener
{
	private static final long serialVersionUID = 1L;
	
// Buchnreferenz
	private Buch 			buch;
	private Object[] 		filterWerte;
		
// Tabellen Elemente	
	private JTable 			tabelle;
	private SpaltenModel 	sData;
	private TabelleModel	tData;
	
// Schalter und Label (Werte aus TextData)	
	private JButton			buttonOk 		= new JButton(BUTTON_OK);
	private JButton			buttonAbbrechen = new JButton(BUTTON_ABBRECHEN);
	private JButton			buttonFilter	= new JButton(BUTTON_FILTER);
	private JLabel			labelText1 		= new JLabel(TEXT_TABELLE_1);
	private JLabel			labelText2 		= new JLabel(TEXT_TABELLE_2);
	
	public DialogBuchAuswahlViewController(Frame frame, Buch buch)
	{
		super(frame, TITEL_BUCH_FILTER, true);
		this.buch = buch;
		this.buch.reset();
		
	// Obere Bereich mit Textausgabe
		Container obenPane = new Container();
		obenPane.setLayout(new GridLayout(2,1));
		obenPane.add(labelText1);
		obenPane.add(labelText2);
		
	// Mittlerer Bereich mit Auswahltabelle
		filterWerte 	= buch.getWerte();
		tData 			= new TabelleModel(BUCH, filterWerte);
		sData 			= new SpaltenModel(BUCH);
		tabelle 		= new JTable(tData, sData);
		tabelle.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane mittePane = new JScrollPane(tabelle);
		
	// Unterer Bereich mit Schalter
		Container untenPane = new Container();
		untenPane.setLayout(new FlowLayout());
		untenPane.add(buttonFilter);
		untenPane.add(buttonOk);
		untenPane.add(buttonAbbrechen);
		
	// Fensterlayout aus einzelkomponenten zusammenbauen
		Container contentPane = this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.PAGE_START, obenPane);
		contentPane.add(BorderLayout.CENTER, mittePane);
		contentPane.add(BorderLayout.PAGE_END, untenPane);
		
	//Listener registrieren
		buttonFilter.addActionListener(this);
		buttonOk.addActionListener(this);
		buttonAbbrechen.addActionListener(this);		
		
	// Sonstige Fenstereinstellungen
		this.setSize(600, 300);
		this.setLocationRelativeTo(null);
	}
	
	@Override
	public void actionPerformed(ActionEvent e)
	{
	// OK-Schalter
		if(e.getSource() == buttonFilter)
		{
			DialogBuchFilterViewController filterDialog = new DialogBuchFilterViewController(this, this.buch);
			filterDialog.setVisible(true);
			filterWerte = buch.getWerte();
			tData.setFilterWerte(filterWerte);	
			tData.fireTableStructureChanged();
		}
	// OK-Schalter
		if(e.getSource() == buttonOk)
		{
			int rowIndex = tabelle.getSelectedRow();
			if (rowIndex == FEHLER)	
			{// KEINE Zeile wurde ausgewhlt
				buch.reset();				
			}
			else
			{//genau EINE Zeile wurde ausgewhlt
				BigInteger idBuch = tData.getIdFromRow(rowIndex);
				buch.bestimmen(idBuch);
				
				
				//Object[] werte = tData.getRowValues(rowIndex);
				//buch.setWerte(werte);
			}
			this.setVisible(false);
			this.dispose();
		}
	// Abbrechen-Schlter
		if(e.getSource() == buttonAbbrechen)
		{
			buch.reset();
			this.setVisible(false);
			this.dispose();
		}
		buch.showBuch(); // abschaltbare Kontrollausgabe		
	}
}
