package buecherei;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class DialogBuchFilterViewController extends JDialog implements _DatenbankDaten, _StringDaten, ActionListener
{
	private static final long serialVersionUID = 1L;
	
// Kundenreferenz
	private Buch buch;
	
// Schalter und Label (Werte aus TextData)	
	private JButton		buttonFilterAn 		= new JButton(BUTTON_FILTER_AN);
	private JButton		buttonFilterAus		= new JButton(BUTTON_FILTER_AUS);
	private JLabel		labelText 			= new JLabel(TEXT_BUCH);
		
//Textfelder
	private JTextField	textFieldIsbn		= new JTextField("", 20);
	private JTextField	textFieldTitel		= new JTextField("", 20);
	private JTextField	textFieldVorname	= new JTextField("", 20);
	private JTextField	textFieldNachname	= new JTextField("", 20);

// Konstruktor
	public DialogBuchFilterViewController(JDialog frame, Buch buch)
	{
		super(frame, TITEL_BUCH, true);
		this.buch = buch;
		
	// Textfelder setzen
		String s;
		s = buch.getIsbn();		if (s!=null) textFieldIsbn 		= new JTextField(s, 20);
		s = buch.getTitel();	if (s!=null) textFieldTitel 	= new JTextField(s, 20);
		s = buch.getVorname();	if (s!=null) textFieldVorname 	= new JTextField(s, 20);
		s = buch.getNachname();	if (s!=null) textFieldNachname 	= new JTextField(s, 20);
	
	// Mittlerer Bereich mit eingabefelder
		Container mittePane = new Container();
		mittePane.setLayout(new GridLayout(4,2));
		mittePane.add(new JLabel(BUCH_ISBN));		mittePane.add(textFieldIsbn);
		mittePane.add(new JLabel(BUCH_TITEL));		mittePane.add(textFieldTitel);
		mittePane.add(new JLabel(BUCH_VORNAME));	mittePane.add(textFieldVorname);
		mittePane.add(new JLabel(BUCH_NACHNAME));	mittePane.add(textFieldNachname);
						
	// Unterer Bereich mit Schalter
		Container untenPane = new Container();
		untenPane.setLayout(new FlowLayout());
		untenPane.add(buttonFilterAn);
		untenPane.add(buttonFilterAus);
		
	// Fensterlayout aus Einzelkomponenten zusammenbauen
		Container contentPane = this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.PAGE_START, labelText);
		contentPane.add(BorderLayout.CENTER, mittePane);
		contentPane.add(BorderLayout.PAGE_END, untenPane);
				
	//Listener registrieren
		buttonFilterAn.addActionListener(this);
		buttonFilterAus.addActionListener(this);
		
	// Sonstige Fenstereinstellungen
		this.pack();
		this.setLocationRelativeTo(null);
	}

// Umsetzung des ActionListeners (Schalter Controller)
	public void actionPerformed(ActionEvent e)
	{		
	// OK-Schalter
		if(e.getSource() == buttonFilterAn)
		{	//Filterdaten setzen
			String s;
			s = textFieldIsbn.getText();		if(!s.equals("")) buch.setIsbn(s);
			s = textFieldTitel.getText();		if(!s.equals("")) buch.setTitel(s);
			s = textFieldVorname.getText();		if(!s.equals("")) buch.setVorname(s);
			s = textFieldNachname.getText();	if(!s.equals("")) buch.setNachname(s);
		}
	// Abbrechen-Schalter
		else
		{	//Filter lschen
			buch.reset();
		}
		buch.showBuch();
		this.setVisible(false);
		this.dispose();
	}
}
