package buecherei;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class DialogKundeFilterViewController extends JDialog implements _DatenbankDaten, _StringDaten, ActionListener
{
	private static final long serialVersionUID = 1L;
	
// Kundenreferenz
	private Kunde kunde;
	
// Schalter und Label (Werte aus TextData)	
	private JButton		buttonFilterAn 		= new JButton(BUTTON_FILTER_AN);
	private JButton		buttonFilterAus		= new JButton(BUTTON_FILTER_AUS);
	private JLabel		labelText 			= new JLabel(TEXT_KUNDE);
		
//Textfelder
	private JTextField	textFieldKundennr	= new JTextField("", 20);
	private JTextField	textFieldVorname	= new JTextField("", 20);
	private JTextField	textFieldNachname	= new JTextField("", 20);
	private JTextField	textFieldStrasse	= new JTextField("", 20);
	private JTextField	textFieldPlz		= new JTextField("", 20);
	private JTextField	textFieldOrt		= new JTextField("", 20);	
	
// Konstruktor
	public DialogKundeFilterViewController(JDialog frame, Kunde kunde)
	{
		super(frame, TITEL_KUNDE, true);
		this.kunde = kunde;
		
	// Textfelder setzen
		String s;
		s = kunde.getKundennr();	if (s!=null) textFieldKundennr	= new JTextField(s, 20);
		s = kunde.getVorname();		if (s!=null) textFieldVorname 	= new JTextField(s, 20);
		s = kunde.getNachname();	if (s!=null) textFieldNachname 	= new JTextField(s, 20);
		s = kunde.getStrasse();		if (s!=null) textFieldStrasse 	= new JTextField(s, 20);
		s = kunde.getPlz();			if (s!=null) textFieldPlz		= new JTextField(s, 20);
		s = kunde.getOrt();			if (s!=null) textFieldOrt 		= new JTextField(s, 20);
			
	// Mittlerer Bereich mit eingabefelder
		Container mittePane = new Container();
		mittePane.setLayout(new GridLayout(6,2));
		mittePane.add(new JLabel(KUNDE_KUNDENNR));	mittePane.add(textFieldKundennr);
		mittePane.add(new JLabel(KUNDE_VORNAME));	mittePane.add(textFieldVorname);
		mittePane.add(new JLabel(KUNDE_NACHNAME));	mittePane.add(textFieldNachname);
		mittePane.add(new JLabel(KUNDE_STRASSE));	mittePane.add(textFieldStrasse);
		mittePane.add(new JLabel(KUNDE_PLZ));		mittePane.add(textFieldPlz);
		mittePane.add(new JLabel(KUNDE_ORT));		mittePane.add(textFieldOrt);
				
	// Unterer Bereich mit Schalter
		Container untenPane = new Container();
		untenPane.setLayout(new FlowLayout());
		untenPane.add(buttonFilterAn);
		untenPane.add(buttonFilterAus);
		
	// Fensterlayout aus einzelkomponenten zusammenbauen
		Container contentPane = this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.PAGE_START, labelText);
		contentPane.add(BorderLayout.CENTER, mittePane);
		contentPane.add(BorderLayout.PAGE_END, untenPane);
		
	//Listener registrieren
		buttonFilterAn.addActionListener(this);
		buttonFilterAus.addActionListener(this);
		
	// Sonstige Fenstereinstellungen
		this.pack();
		this.setLocationRelativeTo(null);
		
	}

// Umsetzung des ActionListeners (Schalter Controller)
	public void actionPerformed(ActionEvent e)
	{		
	// OK-Schalter
		if(e.getSource() == buttonFilterAn)
		{	//Filterdaten setzen
			String s;
			s = textFieldKundennr.getText();	if(!s.equals("")) kunde.setKundennr(s);
			s = textFieldVorname.getText();		if(!s.equals("")) kunde.setVorname(s);
			s = textFieldNachname.getText();	if(!s.equals("")) kunde.setNachname(s);
			s = textFieldStrasse.getText();		if(!s.equals("")) kunde.setStrasse(s);
			s = textFieldPlz.getText();			if(!s.equals("")) kunde.setPlz(s);
			s = textFieldOrt.getText();			if(!s.equals("")) kunde.setOrt(s);
		}
	// Abbrechen-Schalter
		else
		{	//Filter lschen
			kunde.reset();
		}
		kunde.showKunde();
		this.setVisible(false);
		this.dispose();
	}
}
