package buecherei;

import java.math.BigInteger;

import javax.swing.table.AbstractTableModel;

/**
 * 
 * @author vjanssen
 *
 * Es wird KEIN! SQL direkt verwendet 			-> Zugriff ber QueryControll
 * Es wird KEIN! DB-Zugriff direkter ausgefhrt	-> Zugriff ber DbControll
 * 
 */
public class TabelleModel extends AbstractTableModel implements _DatenbankDaten
{
	private static final long serialVersionUID = 1L;
	
	// Datenbank Verbindungsdaten
	private DatenbankController	db;							// Datenbank
	private int					tabellenIndex;				// TabellenIndex	
	private String[]           	filterMerkmale;				// Filter fr die Datenanzeige
	private Object[]           	filterWerte;				// Merkmale und Werte knnen vorgegeben werden
	
	private int 				zeilen = FEHLER;			// Zeilenanzahl speichern (nur 1x auf DB zugreifen!) 

	public TabelleModel(int tabellenIndex, Object[] filterWerte)
	{
		db = new DatenbankController();
		this.tabellenIndex = tabellenIndex;
		this.filterMerkmale = spaltenNamen[tabellenIndex];
		this.filterWerte = filterWerte;
	}
	
	/**
	 * Neue Filterwerte Einstellen
	 * Zeilenanzahl muss daraufhin neu angepasst werden (zeilen = FEHLER)
	 * @param filterWerte		Werte nach denen gefiltert werden muss.
	 */
	public void setFilterWerte(Object[] filterWerte)
	{
		this.filterWerte = filterWerte;
		this.zeilen = FEHLER;
	}
	
	/**
	 * Ermittelt die Anzahl der Tabellenzeilen aus der Datenbank beim ersten Aufruf
	 * Bei jedem weiteren Aufruf wird nur noch der gespeicherte Wert zurck gegeben
	 * Soll die Zeilenanzahl neu bestimmt werden this.Zeilen auf _DatenbankDaten.FEHLER setzen
	 * @return
	 */
	public int getRowCount()
	{
		if (this.zeilen == FEHLER)
		{
			String query = DatenbankQuery.makeQuery(DatenbankQuery.AbfrageTyp.ANZAHL, tabellenIndex, filterMerkmale, filterWerte);
			Object wert = db.dbGetValueAt(query, 0, 0);
			if (wert!=null)	this.zeilen = (int)(long) wert;
			else			this.zeilen = 0;
		}
		return zeilen;
	}
	
	/**
	 * Erlaubt das Zurcksetzen des Zeilenzhlers
	 * Dadurch wird beim nchsten Aufruf der Methode getRowCounter
	 * die Zeilenzahl erneut aus der Tabelle direkt bestimmt
	 */
	public void resetZeilen()
	{
		this.zeilen = FEHLER;
	}
	
	public int getColumnCount()
	{
		return spaltenNamen[tabellenIndex].length;
	}

	public Object getValueAt(int rowIndex, int columnIndex)
	{	
		String query = DatenbankQuery.makeQuery(DatenbankQuery.AbfrageTyp.FILTER, tabellenIndex, filterMerkmale, filterWerte);
		return db.dbGetValueAt(query, rowIndex, columnIndex);
	}
			
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Class getColumnClass(int columnIndex)
    {  	// Wird zum Layouten der Werte bentigt
        return spaltenTypen[tabellenIndex][columnIndex];
    }

	public boolean isCellEditable(int rowIndex, int columnIndex)
	{	// Alle Zellen auer ID-Wert nderbar
		return sapltenEditierbar[tabellenIndex][columnIndex];
	}
	
	/**
	 * Gibt den ID-Wert einer angegebenen Tabellenzeile Zurck
	 * Die ID ist biem Datenbankzugriff wichtig
	 * @param rowIndex	Index der Zeile
	 * @return			Datensatz-ID als BigInteger
	 */
	public BigInteger getIdFromRow(int rowIndex)
	{
		String query = DatenbankQuery.makeQuery(DatenbankQuery.AbfrageTyp.ID, tabellenIndex, filterMerkmale, filterWerte);
		return (BigInteger)db.dbGetValueAt(query, rowIndex, 0);
	}	
	
	public void setValueAt(Object wert, int rowIndex, int columnIndex )
	{
		String[] merkmale 	= {spaltenNamen[tabellenIndex][columnIndex]};
		Object[] werte 		= {wert};
		BigInteger idWert = getIdFromRow(rowIndex);
		String query = DatenbankQuery.makeUpdate(tabellenIndex, idWert, merkmale, werte);
		db.dbUpdate(query);
	}	
}
