package buechereiNichtOptimiert;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AnwendungsfallAusleihenVC extends JFrame implements _DatenbankDaten, _StringDaten, ActionListener
{
	private static final long serialVersionUID = 1L;
	
	// Kunde und Buch
	private Kunde 		kunde 	= new Kunde();
	private Buch 		buch 	= new Buch();
	
	// Schalter und Label (Werte aus TextData)	
	private JButton			buttonOk		= new JButton(BUTTON_OK);
	private JButton			buttonAbbrechen = new JButton(BUTTON_ABBRECHEN);
	private JButton			buttonKunde		= new JButton(BUTTON_KUNDE);
	private JButton			buttonBuch		= new JButton(BUTTON_BUCH);
	
	private JLabel			labelFrist 		= new JLabel(LABEL_FRIST);
		
	private JTextArea		areaKunde		= new JTextArea(kunde.getKunde(), 10, 30);	
	private JTextArea		areaBuch 		= new JTextArea(buch.getBuch(), 10, 30);
	
	// Eingabefelder
	private JFormattedTextField		frist;

	public AnwendungsfallAusleihenVC()
	{
		super(TITEL_AUSLEIHE);
				
		// Formatierung fr Textfeld festlegen
		DateFormat format = DateFormat.getDateInstance();
		frist = new JFormattedTextField(format);
		
		// TextArea nur als Textanzeige gedacht
		areaKunde.setEditable(false);
		areaBuch.setEditable(false);
				
		// Oberer Bereich Eingabe der Ausleihfrist
		Container obenPane = new Container();
		obenPane.setLayout(new GridLayout(1,2));
		obenPane.add(labelFrist);
		obenPane.add(frist);
				
		// Unterer Bereich mit Schalter
		Container untenPane = new Container();
		untenPane.setLayout(new FlowLayout());
		untenPane.add(buttonKunde);
		untenPane.add(buttonBuch);
		untenPane.add(buttonOk);
		untenPane.add(buttonAbbrechen);
		
		// Fensterlayout aus Einzelkomponenten zusammenbauen
		Container contentPane = this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.PAGE_START, obenPane);
		contentPane.add(BorderLayout.LINE_START, areaKunde);
		contentPane.add(BorderLayout.LINE_END, areaBuch);
		contentPane.add(BorderLayout.PAGE_END, untenPane);
		
		// Sonstige Fenstereinstellungen
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setSize(700, 400);
		this.setVisible(true);
		
		//Listener registrieren
		buttonKunde.addActionListener(this);
		buttonBuch.addActionListener(this);
		buttonOk.addActionListener(this);
		buttonAbbrechen.addActionListener(this);
		this.setVisible(true);		
	}

	@Override
	public void actionPerformed(ActionEvent e)
	{
		
	// Kunde-Schalter
		if(e.getSource() == buttonKunde)
		{	// Kunde Identifizieren - Filterdaten setzen
			DialogKundeAuswahlViewController vkt = new DialogKundeAuswahlViewController(this, kunde);
			vkt.setVisible(true);
			areaKunde.setText(kunde.getKunde());
		}
	// Buch-Schalter
		if(e.getSource() == buttonBuch)
		{	// Buch Identifizieren - Filterdaten setzen
			DialogBuchAuswahlViewController vbt = new DialogBuchAuswahlViewController(this, buch);
			vbt.setVisible(true);
			areaBuch.setText(buch.getBuch());
		}
	// OK Schalter (Ausleihe)
		if(e.getSource() == buttonOk)
		{	
			BigInteger 	idBuch 	= buch.getIdBuch();
			String 		idKunde	= kunde.getIdKunde().toString();
			String		frist	= this.frist.getText();
			
			
			
			/*
			if (		!buch.getIdBuch().equals(new BigInteger("0")	// Buch ausgewhlt
					&&	!kunde.getIdKunde().equals(new BigInteger("0")	// Kunde ausgewhlt
					&& 	!frist.getText().equals(""))					// Ausleifrist angegeben
			{
				DatenbankQueryHilfsfunktionen.makeUpdate(BUCH, buch.iidWert, merkmale, werte)
				DatenbankController	db = new DatenbankController();							// Datenbank

			}
			*/
		}
		
		/*
	// Abbrechen-Schlter
		else
		{	//Filter lschen
			kunde.reset();
		}
		kunde.showKunde(); // abschaltbare Kontrollausgabe
		this.setVisible(false);
		this.dispose();
		*/
	}
}
