package buechereiNichtOptimiert;

import java.math.BigInteger;
import java.util.Date;

public class Buch implements _Debug
{
	private BigInteger	idBuch;
	private String 		isbn;
	private String 		titel;
	private String 		vorname;	//Autor des Buches
	private String 		nachname; 	//Autor des Buches
	
	//Referenz auf den Kunden der das Buch ausleiht
	private BigInteger 	idKunde;	// ausleihender Kunde
	private Date 		frist;		// Datum der Rckgabe
	
	public Buch()					// legt leeres Buchobjekt an
	{
		super();
		this.reset();
	}
	
	public void setIdBuch (BigInteger idBuch)
	{
		this.idBuch = idBuch;
	}
	
	public BigInteger getIdBuch ()
	{
		return this.idBuch;
	}
	
	public void setIsbn(String isbn)
	{
		this.isbn = isbn;
	}
	
	public String getIsbn()
	{
		return isbn;
	}
	
	public void setTitel(String titel)
	{
		this.titel = titel;
	}
	
	public String getTitel()
	{
		return this.titel;
	}
	
	public void setVorname(String vorname)
	{
		this.vorname = vorname;
	}
	
	public String getVorname()
	{
		return this.vorname;
	}
	
	public void setNachname(String nachname)
	{
		this.nachname = nachname;
	}
	
	public String getNachname()
	{
		return this.nachname;
	}
	
	
	public void setIdKunde(BigInteger idKunde)
	{
		this.idKunde= idKunde;
	}
	
	public void setAusleifrist(Date ausleifrist)
	{
		this.frist= ausleifrist;
	}
	
	public void reset()
	{
		this.idBuch		= null;
		this.isbn		= null;
		this.titel		= null;		
		this.vorname	= null;
		this.nachname	= null;
		this.idKunde	= null;	
		/*
		//Datum auf das Jahr 0 ... setzen
		Calendar cal = Calendar.getInstance();
		cal.set(1,1,1,0,0,0);
		this.frist = cal.getTime();
		*/
		this.frist		= null;
	}
	
	public void setWerte(Object[] werte)
	{
		this.idBuch 	= (BigInteger)	werte[0];
		this.isbn		= (String) 		werte[1];
		this.titel		= (String)		werte[2];
		this.vorname	= (String)		werte[3];
		this.nachname	= (String)		werte[4];
		this.idKunde	= new BigInteger(werte[5].toString());		
		this.frist		= (Date)		werte[6];		
	}
	
	public Object[] getWerte()
	{
		/*
		// Zahelnwerte und Datum in String umwandeln 
		String idBuch	= this.idBuch.toString();
		if (idBuch.equals("0")) idBuch = "";
		String idKunde = "";
		if (this.idKunde == 0) idKunde = "";
		
		//Datumsangabe prfen
		String frist = "";
		Calendar cal = Calendar.getInstance();
		cal.setTime(this.frist);
		if (cal.get(Calendar.YEAR) == 1) frist="";
		
		// Rckgabe-Array zusammenbauen
		 
		 */
		Object[] s = {
				idBuch,
				isbn, 
				titel, 
				vorname,
				nachname, 
				idKunde,
				frist}; 
		return s;
	}
	
	public String getBuch()
	{
		String s = 	"_____ BUCH _____\n";
		if (this.idBuch!=null)
		{			
			s = s 	+ 	"ID_Buch: \t"	+ this.idBuch 	+ "\n"
					+ 	"ISBN: \t" 		+ this.isbn 	+ "\n"
					+ 	"Titel: \t" 	+ this.titel 	+ "\n"
					+ 	"Vorname: \t" 	+ this.vorname  + " (Autor)\n"
					+ 	"Nachname: \t" 	+ this.nachname + " (Autor)\n"
					+ 	"ID-Kunde: \t" 	+ this.idKunde	+ " (Ausleiher)\n"
					+ 	"Frist: \t" 	+ this.frist	+ " (Zurck)\n";
		}
		return s;
	}	
	
	public void showBuch()
	{
		if (TESTMODUS)
		{
			System.out.println(this.getBuch());
		}
	}
}
