package buechereiNichtOptimiert;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * 
 * @author vjanssen
 *
 * Bietet Funktionen fr den Zugriff auf die konkrete Datenbank
 * Entkoppelt das Projekt vom Datenbankserver MariaSql
 * 
 */
public class DatenbankController implements _DatenbankDaten
{
	// Datenbank Verbindungsdaten
	private static Connection con = null; // Vebindungsreferenz
	private Statement stm; // DB-Abfrage-Statement
	
// Konstruktor
	
	/**
	 * Datenbankverbindung aufbauen
	 */
	public DatenbankController()
	{
		try
		{
			Class.forName("com.mysql.jdbc.Driver");

			String s = "jdbc:mysql://" + host + ":" + port + "/" + db + "?"	+ "user=" + user + "&" + "password=" + passwd;

			con = DriverManager.getConnection(s);
			stm = con.createStatement();
		} 
		catch (ClassNotFoundException e)
		{
			System.err.println("Fehler DatenbankController: Treiber nicht mglich! (JDBC-Treiber nicht installiert?)");
		} 
		catch (SQLException e)
		{
			System.err.println("Fehler DatenbankController: Connect nicht moeglich! (Datenbankserver nicht gestartet?)");
		}
		catch (Exception e)
		{
			System.err.println("Fehler DatenbankController: " + e.getMessage());
		}
	}
	
//Objektmethoden	
	
	/**
	 * Datenbank-Abfrage ausfhren und Cursor auf Anfang Positionieen
	 * @param sql Datenbankabfrage
	 * @return ResultSet Abfrageergebnis
	 */
	public ResultSet dbQuery(String sql)
	{
		try
		{
			ResultSet rs = stm.executeQuery(sql);
			return rs;
		} 
		catch (Exception e)
		{
			System.err.println("Fehler dbQuery: " + e.getMessage());
			return null;
		}
	}
	
	/**
	 * Datenbank-Update ausfhren
	 * @param sql Update-Anweisung
	 * @return boolean true=OK / false=fehler
	 */
	public boolean dbUpdate(String sql)
	{
		try
		{
			stm.executeUpdate(sql);
			return true;
		} 
		catch (SQLException e)
		{
			System.err.println("Fehler dbUpdate: " + e.getMessage());
			return false;
		}
	}

	/**
	 * Zelleninhalt eines Abfrageergebnisses bestimmen
	 * @param sql Datenbankabfrage
	 * @param rowIndex Zeile
	 * @param columnIndex Spalte
	 * @return Object Zelleninhalt
	 */
	public Object dbGetValueAt(String sql, int rowIndex, int columnIndex)
	{
		try
		{
			ResultSet rs = dbQuery(sql);
			for (int i = 0; i <= rowIndex; i++) rs.next();
			return rs.getObject(columnIndex + 1);
		}
		catch (Exception e)
		{
			System.err.println("Fehler dbGetValueAt: " + e.getMessage());
			return null;
		}
	}
	
	/**
	 * Zeileninhalt als Objektarray zurckgeben
	 * @param sql Datenbankabfrage
	 * @param rowIndex Zeile
	 * @param columnAnzah Anzahl der Spalten
	 * @return Array vom Typ Object mit den Zeilenwerten
	 */
	public Object[] dbGetRowValues(String sql, int rowIndex, int columnAnzahl)
	{
		Object[] werte = new Object[columnAnzahl];
		
		try
		{
			ResultSet rs = dbQuery(sql);
			for (int i = 0; i <= rowIndex; i++) rs.next();
			for (int i = 0; i < columnAnzahl; i++)
				werte[i] = rs.getObject(i+1);
		}
		catch (SQLException e)
		{
			System.err.println("Fehler dbGetRowValues: " + e.getMessage());
			return null;
		}
		
		return werte;
	}
}
