package buechereiNichtOptimiert;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class DialogKundeAuswahlViewController extends JDialog implements _DatenbankDaten, _StringDaten, ActionListener
{
	private static final long serialVersionUID = 1L;
	
	// Kundenreferenz
	private Kunde kunde;
	private Object[] filterWerte;
		
	// Tabellen Elemente	
	private JTable 			tabelle;
	private SpaltenModel 	sData;
	private TabelleModel	tData;
	
	// Schalter und Label (Werte aus TextData)	
	private JButton			buttonOk 		= new JButton(BUTTON_OK);
	private JButton			buttonAbbrechen = new JButton(BUTTON_ABBRECHEN);
	private JButton			buttonFilter	= new JButton(BUTTON_FILTER_AN);
	private JLabel			labelText1 		= new JLabel(TEXT_TABELLE_1);
	private JLabel			labelText2 		= new JLabel(TEXT_TABELLE_2);
	
	public DialogKundeAuswahlViewController(Frame frame, Kunde kunde)
	{
		super(frame, TITEL_KUNDE_FILTER, true);
		this.kunde = kunde;
		this.kunde.reset();
		
		// Obere Bereich mit Textausgabe
		Container obenPane = new Container();
		obenPane.setLayout(new GridLayout(2,1));
		obenPane.add(labelText1);
		obenPane.add(labelText2);
		
		// Mittlerer Bereich mit Auswahltabelle
		filterWerte 	= kunde.getWerte();
		tData 			= new TabelleModel(KUNDE, filterWerte);
		sData 			= new SpaltenModel(KUNDE);
		tabelle 		= new JTable(tData, sData);
		tabelle.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane mittePane = new JScrollPane(tabelle);
		
		// Unterer Bereich mit Schalter
		Container untenPane = new Container();
		untenPane.setLayout(new FlowLayout());
		untenPane.add(buttonFilter);
		untenPane.add(buttonOk);
		untenPane.add(buttonAbbrechen);
		
		// Fensterlayout aus einzelkomponenten zusammenbauen
		Container contentPane = this.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.PAGE_START, obenPane);
		contentPane.add(BorderLayout.CENTER, mittePane);
		contentPane.add(BorderLayout.PAGE_END, untenPane);
		
		// Sonstige Fenstereinstellungen
		this.setSize(600, 500);
		
		//Listener registrieren
		buttonFilter.addActionListener(this);
		buttonOk.addActionListener(this);
		buttonAbbrechen.addActionListener(this);		
	}
	
	@Override
	public void actionPerformed(ActionEvent e)
	{
	// OK-Schalter
		if(e.getSource() == buttonFilter)
		{
			DialogKundeFilterViewController filterDialog = new DialogKundeFilterViewController(this, this.kunde);
			filterDialog.setVisible(true);
			filterWerte = kunde.getWerte();
			tData.setFilterWerte(filterWerte);
			tData.fireTableStructureChanged();
		}
	// OK-Schalter
		if(e.getSource() == buttonOk)
		{
			int rowIndex = tabelle.getSelectedRow();
			if (rowIndex != -1)	// Zeile wurde ausgewhlt
			{
				Object[] werte = tData.getRowValues(rowIndex);
				kunde.setWerte(werte);
			}
			else // keine Zeile ausgewhlt
			{
				kunde.reset();
			}
			this.setVisible(false);
			this.dispose();
		}
	// Abbrechen-Schlter
		if(e.getSource() == buttonAbbrechen)
		{
			kunde.reset();
			this.setVisible(false);
			this.dispose();
		}
		kunde.showKunde(); // abschaltbare Kontrollausgabe		
	}
}
