package buechereiNichtOptimiert;

import java.math.BigInteger;

import javax.swing.table.AbstractTableModel;

/**
 * 
 * @author vjanssen
 *
 * Es wird KEIN! SQL direkt verwendet 			-> Zugriff ber QueryControll
 * Es wird KEIN! DB-Zugriff direkter ausgefhrt	-> Zugriff ber DbControll
 * 
 */
public class TabelleModel extends AbstractTableModel implements _DatenbankDaten
{
	private static final long serialVersionUID = 1L;
	
	// Datenbank Verbindungsdaten
	private DatenbankController	db;							// Datenbank
	private int					tabellenIndex;				// TabellenIndex	
	private String[]           	filterMerkmale;				// Filter fr die Datenanzeige
	private Object[]           	filterWerte;				// Merkmale und Werte knnen vorgegeben werden

	public TabelleModel(int tabellenIndex, Object[] filterWerte)
	{
		db = new DatenbankController();
		this.tabellenIndex = tabellenIndex;
		this.filterMerkmale = spaltenNamen[tabellenIndex];
		this.filterWerte = filterWerte;
	}
	
	public void setFilterWerte(Object[] filterWerte)
	{
		this.filterWerte = filterWerte;
	}
	
	public int getRowCount()
	{	
		String query = DatenbankQuery.makeQuery(DatenbankQuery.AbfrageTyp.ANZAHL, tabellenIndex, filterMerkmale, filterWerte);
		Object wert = db.dbGetValueAt(query, 0, 0);
		if (wert!=null)	return (int)(long) wert;
		else			return 0;
	}
	
	public int getColumnCount()
	{
		return spaltenNamen[tabellenIndex].length;
	}

	public Object getValueAt(int rowIndex, int columnIndex)
	{	
		String query = DatenbankQuery.makeQuery(DatenbankQuery.AbfrageTyp.FILTER, tabellenIndex, filterMerkmale, filterWerte);
		return db.dbGetValueAt(query, rowIndex, columnIndex);
	}
	
	public Object[] getRowValues(int rowIndex)
	{
		BigInteger idWert = getIdFromRow(rowIndex);
		String query = DatenbankQuery.makeQuery(tabellenIndex, idWert);
		return db.dbGetRowValues(query, 0, getColumnCount());		
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Class getColumnClass(int columnIndex)
    {  	// Wird zum Layouten der Werte bentigt
        return spaltenTypen[tabellenIndex][columnIndex];
    }

	public boolean isCellEditable(int rowIndex, int columnIndex)
	{	// Alle Zellen auer ID-Wert nderbar
		return sapltenEditierbar[tabellenIndex][columnIndex];
	}
	
	public BigInteger getIdFromRow(int rowIndex)
	{
		String query = DatenbankQuery.makeQuery(DatenbankQuery.AbfrageTyp.ID, tabellenIndex, filterMerkmale, filterWerte);
		return (BigInteger)db.dbGetValueAt(query, rowIndex, 0);
	}	
	
	public void setValueAt(Object wert, int rowIndex, int columnIndex )
	{
		String[] merkmale 	= {spaltenNamen[tabellenIndex][columnIndex]};
		Object[] werte 		= {wert};
		BigInteger idWert = getIdFromRow(rowIndex);
		String query = DatenbankQuery.makeUpdate(tabellenIndex, idWert, merkmale, werte);
		db.dbUpdate(query);
	}	
}
