package excFile07files;

import java.io.IOException;
import java.nio.file.*;

public class StartFile
{

	public static void main(String[] args)
	{
		Path pfad = Paths.get("D:\\myProjekt\\java\\data\\Daten.txt");

		// Existenz
		System.out.println("exist: \t\t" + Files.exists(pfad));
		System.out.println("notExist: \t" + Files.notExists(pfad));
		
		// Art der Datei
		System.out.println("Verzeichnis: \t" + Files.isDirectory(pfad));
		System.out.println("Datei: \t\t" + Files.isRegularFile(pfad));
		System.out.println("Link: \t\t" + Files.isSymbolicLink(pfad));
		try
		{
			System.out.println("Versteckt: \t" + Files.isHidden(pfad));
			System.out.println("Dateityp: \t" + Files.probeContentType(pfad)); 
		}
		catch (IOException io)
		{
			System.out.println(io.toString());
		}
		
		// Zugriffsrechte
		System.out.println("Leserecht: \t" + Files.isReadable(pfad));
		System.out.println("Schreibrecht: \t" + Files.isWritable(pfad));
		System.out.println("Ausfhrbar: \t" + Files.isExecutable(pfad));
		
		// Gre
		try
		{
			System.out.println("Gre: \t\t" + Files.size(pfad));
		}
		catch (IOException io)
		{
			System.out.println(io.toString());
		}
	}
}
