package excFile10zeilenweise;

import java.io.*;
import java.nio.charset.*;
import java.nio.file.*;
import java.util.*;



public class StartFile
{

	public static void main(String[] args)
	{
		Path pfad = Paths.get("D:\\myProjekt\\java\\data\\Daten.txt");

		if (	Files.exists(pfad)
				&&	Files.isRegularFile(pfad)
				&&	Files.isReadable(pfad)
				&&	Files.isWritable(pfad)	)
		{
			
			// Liste von Stribs erzeugen
			List<String> out = new ArrayList<>();
			out.add("Dieser Text steht\n");
			out.add("in der Datei Daten.txt\n");	
			
			// Einzelne Strings-Zeilen schreiben
			try (BufferedWriter writer = Files.newBufferedWriter(pfad, Charset.defaultCharset()))
			{
				for (String s: out)
				{
					writer.write(s, 0, s.length());
				}
			} 
			catch (IOException io)
			{
				System.out.println(io.toString());
			}
			
			// Einzelne Strings-Zeilen einlesen			
			try (BufferedReader reader = Files.newBufferedReader(pfad, Charset.defaultCharset()))
			{
			    String s = null;
			    while ((s = reader.readLine()) != null)
			    {
			        System.out.println(s);
			    }
			}
			catch (IOException io)
			{
				System.out.println(io.toString());
			}	
		}
	}
}
