package excFile11objekt;

import java.io.*;
import java.nio.file.*;

//ACHTUNG auf Serialisierung achten.

public class StartFile
{
	public static void main(String[] args)
	{
		Path pfad = Paths.get("D:\\myProjekt\\java\\data\\Daten.txt");

		if (	Files.exists(pfad)
				&&	Files.isRegularFile(pfad)
				&&	Files.isReadable(pfad)
				&&	Files.isWritable(pfad)	)
		{
			// Ein komplettes Objekt vom Typ Elefant speichern
			Elefant eOut = new Elefant();
			eOut.showObjektVar();
			
			try (ObjectOutputStream oos = 
					new ObjectOutputStream (
					   new BufferedOutputStream(
						 Files.newOutputStream(pfad))))
			{
				oos.writeObject(eOut);
			}
			catch (IOException io)
			{
				System.out.println(io.toString());
			}
			
			// Ein komplettes Objekt vom Typ Elefant einlesen
			Elefant eIn;
			
			try (ObjectInputStream ois = 
					new ObjectInputStream (
					   new BufferedInputStream (
					      Files.newInputStream(pfad))))
			{
				eIn = (Elefant) ois.readObject();
				eIn.showObjektVar();
			}
			catch (Exception io)
			{
				System.out.println(io.toString());
			}
		}
	}
}
