package excFile12randomAccess;

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.*;
import java.util.List;


public class StartFile
{
	private static Path pfad = Paths.get("D:\\myProjekt\\java\\data\\Daten.txt");

	public static void dateiAnzeige()
	{
		try
		{
			List<String> in = Files.readAllLines(pfad, Charset.defaultCharset());				
			for (String s: in)
				System.out.println(s);
		}
		catch(IOException io)
		{
			System.out.println(io.toString());
		}
	}
	
	public static void main(String[] args)
	{
		dateiAnzeige();
		
		// Neuen Ausgabe generieren
		String s = "\n-> Neuer TEXT <-\n";
		byte data[] = s.getBytes();
		ByteBuffer neu = ByteBuffer.wrap(data);

		ByteBuffer alt = ByteBuffer.allocate(5);

		try (FileChannel fc = (FileChannel.open(pfad, StandardOpenOption.READ , StandardOpenOption.WRITE)))
		{
		    // Erten 5 Zeichen speichern
		    int bytes;
		    do {
		        bytes = fc.read(alt);
		    } while (bytes != -1 && alt.hasRemaining());

		    // Dateianfang mit neuen Zeichen berschreiben
		    fc.position(0);
		    while (neu.hasRemaining())
		        fc.write(neu);
		    neu.rewind();

		    // An das Ende der Datei springen
		    long length = fc.size();
		    fc.position(length-1);
		    
		    // Alten Dateianfang an das Ende Kopieren
		    alt.flip();
		    while (alt.hasRemaining())
		        fc.write(alt);
		} 
		catch (IOException ioe) 
		{
		    System.out.println(ioe.toString());
		}
		
		dateiAnzeige();
		
	}		
}
