package excFile13tree;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.*;



public class MyFileVisitor extends SimpleFileVisitor<Path> 
{
    public FileVisitResult visitFile(Path p, BasicFileAttributes attr)
    {
    	System.out.print(p.getFileName());
    	
    	if (attr.isSymbolicLink())
    		System.out.print("\t->Link: " + p);
    	else if (attr.isRegularFile())
    		System.out.print("\t->Datei: " + p);
    	else 
    		System.out.print("\t->Sonst: " + p);
    		
    	System.out.println("\t(" + attr.size() + " bytes)");
    	
    	return FileVisitResult.CONTINUE;
    }

    public FileVisitResult postVisitDirectory(Path p, IOException ioe)
    {
        System.out.println("Dir: " + p);
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult visitFileFailed(Path p, IOException ioe) 
    {
        System.out.println(ioe.toString());
        return FileVisitResult.CONTINUE;
    }
}
