package genColl04ListeGenerics;

public class Zug<E>
{
	private Wagon<E> Lok;
	
	public Zug(E o)
	{
		Lok = new Wagon<E>(o);
	}
	
	public void addWagon(E o)
	{
		// Starte bei der Lok
		Wagon<E> w = Lok;
		
		// Gehe die Wogons entlag bis der letzte erreicht ist
		while (w.getNext() != null)
		{
			w = w.getNext();
		}
		
		// Erzeuge neuen Wagon
		Wagon<E> neu = new Wagon<E>(o);
		
		// Hnge neuen Wagon an den Letzten Wagon an
		w.setNext(neu);
	}
	
	public E getInhalt (int wagonNummer)
	{
		// Starte bei der Lock
		Wagon<E> w = Lok;
		int wagonZaehler = 0;
				
		// Gehe die Wogons entlag bis zur angegebenen Wagonnummer
		// oder bis der letzte Wagon erreicht ist
		while (		w.getNext() != null			//es gibt noch einen nachfolger
				&&	wagonZaehler < wagonNummer)	// Wagonnummer wurde noch nicht erreicht
		{
			w = w.getNext();
			wagonZaehler = wagonZaehler+1;
		}
		
		// gib den Inhalt des erreichten Wagons zurck
		return w.getInhalt();
	}
	
	private static class Wagon<T>
	{
	// Objektvariablen
		private Wagon<T> next;
		private T inhalt;
		
	// Konstruktoren
		public Wagon (T inhalt)
		{
			this.inhalt = inhalt;
			this.next = null;
		}
		
	// Objektmethoden
		public Wagon<T> getNext()
		{
			return this.next;
		}
		
		public void setNext(Wagon<T> w)
		{
			this.next = w;
		}
		
		public T getInhalt()
		{
			return this.inhalt;
		}
	}
}
