package genColl08Iterator;

import java.util.*;

public class StartListe
{
	public static void main(String[] args)
	{
		// Erzeuge Liste mit 3 Elefanten 
		Zug<Elefant> z = new Zug<>(new Elefant());
		
		z.add(new Elefant("Uwe", 5));
		z.add(new Elefant("Eva", 9));
		
		z.get(0).showObjektVar();
		z.get(1).showObjektVar();
		z.get(2).showObjektVar();		
		
		// Elemente durchlaufen ohne Iteration
		System.out.println("\n -> OHNE Iterator <-");
		for (int i = 0; i< z.size(); i++)
		{
			z.get(i).showObjektVar();
		}
		
		// Elemente durchlaufen mit Iteration (3 Varianten)
		System.out.println("\n -> Mit Iterator - Variante 1");
		Iterator <Elefant> li1 = z.iterator();
		while (li1.hasNext())
		{
			li1.next().showObjektVar();
		}		
		
		System.out.println("\n -> Mit Iterator - Variante 2");
		for (Iterator <Elefant> li2 = z.iterator(); li2.hasNext(); )
		{
			li2.next().showObjektVar();
		}
		
		System.out.println("\n -> Mit Iterator - Variante 3");
		for (Elefant element : z)
		{
			element.showObjektVar();
		}
		
		// Hilfsfunktionen nutzen (Minimum und Maximum bestimmen)
		System.out.println("\n -> Minimum:");
		Collections.min(z).showObjektVar();
		System.out.println("\n -> Maximum:");
		Collections.max(z).showObjektVar();
		
		// Sortieren 
		System.out.println("\n -> Sortiert");
		Collections.sort(z);
		
		for (Elefant element : z)
		{
			element.showObjektVar();
		}				
	}
}
