package jdbc01verbindgung;

import java.sql.*;
import javax.swing.table.AbstractTableModel;

public class ModelTabelle extends AbstractTableModel implements Daten
{
	// Datenbank Verbindungsdaten
		private static Connection 	con 		= null; // Vebindungsreferenz
		private Statement 			stm; 				// DB-Abfrage-Statement

	// Zwischenspeicherung zur Zugriffsoptimoierung
		private int 				zugriff		= 0;
		
	public ModelTabelle()
	{
		try
		{
			/*
			Class.forName("com.mysql.jdbc.Driver");

			String s = 	"jdbc:mysql://" + host 	+
						":" 			+ port 	+ 
						"/" 			+ db 	+ "?" +
						"user=" 		+ user 	+ "&" + 
						"password=" 	+ passwd;

			con = DriverManager.getConnection(s);
			stm = con.createStatement();
			*/
			
			Class.forName("org.mariadb.jdbc.Driver");
			
			String s = 	"jdbc:mariadb://" + host 	+
						":" 			+ port 	+ 
						"/" 			+ db 	+ "?" +
						"user=" 		+ user 	+ "&" + 
						"password=" 	+ passwd;
						
			con = DriverManager.getConnection(s);
			stm = con.createStatement();
		} 
		catch (ClassNotFoundException e)
		{
			System.out.println("Treiber nicht gefunden");
		} 
		catch (SQLException e)
		{
			System.out.println("Connect nicht moeglich");
		}
	}
	
	public int getRowCount()
	{	
		try
		{
			String sql = "SELECT COUNT(*) FROM " + table;
			ResultSet rs = stm.executeQuery(sql);
			rs.next();
			anzeige(sql);
			return rs.getInt(1);
		}
		catch (SQLException e)
		{
			return 0;
		}		
	}
	
	public int getColumnCount()
	{
		return spaltenNamen.length;
	}

	public Object getValueAt(int rowIndex, int columnIndex)
	{	
		try
		{
			String sql = "SELECT * FROM " + table;
			ResultSet rs = stm.executeQuery(sql);
			anzeige(sql);
			rs.beforeFirst();
			for (int i=0; i<=rowIndex;i++)rs.next();
			return rs.getObject(columnIndex+1);
		}
		catch (SQLException e)
		{
			System.out.println("Fehler" + e.getMessage());
			return null;
		}
	}
	
	public Class getColumnClass(int c)
    {  	// Wird zum Layouten der Werte bentigt
        return sapltenTypen[c];
    }

	public boolean isCellEditable(int rowIndex, int columnIndex)
	{	// Alle Zellen nderbar
		// Sonst ber rowIndex und ColumnIndex einschrnken
		if (columnIndex > 0) 	return true;
		else					return false;
	}
	
	public void setValueAt(Object wert, int rowIndex, int columnIndex )
	{
		String 	idName 		= spaltenNamen[0];
		String	columnName 	= spaltenNamen[columnIndex];
		long idWert;
		
		// ID des Datensatzes ermitteln 
		try
		{
			// Boolsche Werte anpassen
			if (wert.toString().equals("true")) wert = new Integer(1);
			if (wert.toString().equals("false")) wert = new Integer(0);
			
			// ID des Datensatzes ermitteln 
			String sql = "SELECT `" + idName + "` FROM `" + table+ "`;";
			ResultSet rs = stm.executeQuery(sql);
			anzeige(sql);
			rs.beforeFirst();
			for (int i=0; i<=rowIndex;i++)rs.next();
			idWert = rs.getLong(1);		
			
			// Updateanweisung zusammenbauen
			sql = 	"UPDATE `" + table + 
					"` SET `" + columnName + 
					"` = '" + wert + 
					"' WHERE `" + idName + 
					"` = " + idWert;
			
			System.out.println("SQL: " + sql);
			
			stm.executeUpdate(sql);
			anzeige(sql);
			
		}
		catch (SQLException e)
		{
			System.out.println("Fehler setValueAt: " + e.getMessage());
		}
	}	
	
	private void anzeige(String sql)
	{
		System.out.print("DB-Zugriff: " + zugriff++);
		System.out.println(" / SQL: " + sql);		
	}
}
