package jdbc02optimiert;

import java.sql.*;
import javax.swing.table.AbstractTableModel;

public class ModelTabelle extends AbstractTableModel implements Daten
{
// Datenbank Verbindungsdaten
	private static Connection 	con 		= null; // Vebindungsreferenz
	private Statement 			stm; 		// DB-Abfrage-Statement

// Zwischenspeicherung zur Zugriffsoptimoierung
	private ResultSet 			rsTabelle 	= null;
	private int 				zeilen 		= 0;
	private int 				zugriff		= 0;
	
	public ModelTabelle()
	{
		try
		{
			Class.forName("com.mysql.jdbc.Driver");

			String s = "jdbc:mysql://" + host + ":" + port + "/" + db + "?"
					+ "user=" + user + "&" + "password=" + passwd;

			con = DriverManager.getConnection(s);
			stm = con.createStatement();
		} catch (ClassNotFoundException e)
		{
			System.out.println("Treiber nicht gefunden");
		} catch (SQLException e)
		{
			System.out.println("Connect nicht moeglich");
		}
		initZeile();
		initTabelle();
	}

	public void initZeile()
	{
		try
		{
			String sql = "SELECT COUNT(*) FROM " + table;
			ResultSet rs = stm.executeQuery(sql);
			anzeige(sql);
			rs.beforeFirst();
			rs.next();
			this.zeilen = rs.getInt(1);
		} 
		catch (SQLException e)
		{
			this.zeilen = 0;
		}	
	}
	
	public void initTabelle()
	{
		try
		{
			String sql = "SELECT * FROM " + table;
			anzeige(sql);
			rsTabelle = stm.executeQuery(sql);
		} 
		catch (SQLException e)
		{
			this.zeilen = 0;
		}
	}
	
	public int getRowCount()
	{
		return this.zeilen;
	}

	public int getColumnCount()
	{
		return spaltenNamen.length;
	}

	public Object getValueAt(int rowIndex, int columnIndex)
	{
		try
		{
			rsTabelle.beforeFirst();
			for (int i = 0; i <= rowIndex; i++)
				rsTabelle.next();
			return rsTabelle.getObject(columnIndex + 1);
		} 
		catch (SQLException e)
		{
			System.out.println("Fehler6" + e.getMessage());
			return null;
		}
	}

	public Class getColumnClass(int c)
	{ // Wird zum Layouten der Werte bentigt
		return sapltenTypen[c];
	}

	public boolean isCellEditable(int rowIndex, int columnIndex)
	{ // Alle Zellen nderbar
		// Sonst ber rowIndex und ColumnIndex einschrnken
		if (columnIndex > 0)
			return true;
		else
			return false;
	}

	public void setValueAt(Object wert, int rowIndex, int columnIndex)
	{
		String idName = spaltenNamen[0];
		String columnName = spaltenNamen[columnIndex];
		long idWert;
		

		// ID des Datensatzes ermitteln
		try
		{
			// Boolsche Werte anpassen
			if (wert.toString().equals("true"))		wert = new Integer(1);
			if (wert.toString().equals("false"))	wert = new Integer(0);

			// ID des Datensatzes ermitteln
			String sql = "SELECT `" + idName + "` FROM `" + table + "`;";
			ResultSet rs = stm.executeQuery(sql);
			anzeige(sql);
			rs.beforeFirst();
			for (int i = 0; i <= rowIndex; i++)
				rs.next();
			idWert = rs.getLong(1);

			// Updateanweisung zusammenbauen
			sql = "UPDATE `" + table + "` SET `" + columnName + "` = '" + wert
					+ "' WHERE `" + idName + "` = " + idWert;
			stm.executeUpdate(sql);
			anzeige(sql);

		} catch (SQLException e)
		{
			System.out.println("Fehler setValueAt: " + e.getMessage());
		}
		this.initTabelle();
	}
	
	private void anzeige(String sql)
	{
		System.out.print("DB-Zugriff: " + zugriff++);
		System.out.println(" / SQL: " + sql);		
	}
}
