package swing01awtAlternative;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class MyFenster implements ActionListener
{
	JFrame frame; 
	
	//Umrechnungskonstanten
	private final static float PS_TO_KW = 0.73f; 
	private final static float KW_TO_PS = 1.36f;
	
	private JTextField ps, kw;
	private JButton um, end;

	public MyFenster()
	{
		frame = new JFrame("Umrechnen"); 
		ps = new JTextField("", 10);
		kw = new JTextField("", 10);
		um  = new JButton("Umrechnen");
		end = new JButton("Beenden");
		
		//Layout
		JPanel p1 = new JPanel(); 
		p1.setLayout(new GridLayout(1, 4));
		p1.add(ps);	p1.add(new Label("=PS"));
		p1.add(kw);	p1.add(new Label("=KW"));
		JPanel p2 = new JPanel();
		p2.setLayout(new BorderLayout());
		p2.add(BorderLayout.CENTER, um);
		p2.add(BorderLayout.LINE_END, end);
		frame.setLayout(new BorderLayout()); 											
		frame.add(BorderLayout.PAGE_START, p1);
		frame.add(BorderLayout.PAGE_END, p2);

		//Listener registrieren
		um.addActionListener(this); // Listener registrieren
		end.addActionListener(this);
		ps.addFocusListener(new MyFocusListener());
		kw.addFocusListener(new MyFocusListener());
		frame.addWindowListener(new MyWindowListener(true)); // MyWindowListener

		frame.setBackground(Color.lightGray); // Sonstige Fenstereinstellungen
		frame.setSize(300, 100);
		frame.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) 
	{
		if (e.getSource() == end)
		{
			System.exit(0);
		}
		if (e.getSource() == um)
		{
			String s_ps, s_kw;
			float f_ps, f_kw;

			// Texte einlesen
			s_ps = ps.getText();
			s_kw = kw.getText();

			if (!s_ps.equals("") && s_kw.equals(""))
			{
				f_ps = Float.valueOf(s_ps).floatValue();
				f_kw = KW_TO_PS * f_ps;
				s_kw = String.valueOf(f_kw);
				kw.setText(s_kw);
			}
			
			if (s_ps.equals("") && !s_kw.equals(""))
			{
				f_kw = Float.valueOf(s_kw).floatValue();
				f_ps = PS_TO_KW * f_kw;
				s_ps = String.valueOf(f_ps);
				ps.setText(s_ps);
			}
		}
	}

	class MyFocusListener extends FocusAdapter
	{
		public void focusGained(FocusEvent e)
		{
			ps.setText("");
			kw.setText(""); 
		}
	}

}
