package swing02look;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class MyFenster implements ActionListener
{
	JFrame frame;
	
	//Look-and-Feel Adressen
	private final static String me = "javax.swing.plaf.metal.MetalLookAndFeel";
	private final static String mo = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
	private final static String wi = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
	private final static String ni = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
	
	private JButton metal, motif, windows, nimbus;
	private JLabel anzeige;

	public MyFenster()
	{
		frame = new JFrame("Look-and-Feel"); 
		metal 	= new JButton("Metal");
		motif	= new JButton("Motif");
		windows	= new JButton("Windows");
		nimbus	= new JButton("Nimbus");
		anzeige = new JLabel("-");
		
		//Layout
		Container contentPane = frame.getContentPane();
		contentPane.setLayout(new FlowLayout());
		contentPane.add(metal);
		contentPane.add(motif);
		contentPane.add(windows);
		contentPane.add(nimbus);
		contentPane.add(anzeige);

		//Listener registrieren
		metal.addActionListener(this); 
		motif.addActionListener(this);
		windows.addActionListener(this);
		nimbus.addActionListener(this);

		// Sonstige Fenstereinstellungen
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(300, 100);
		frame.setBackground(Color.lightGray); 
		frame.setVisible(true);
	}

	public void actionPerformed(ActionEvent ae) 
	{
		String look = "unknown";
		
		switch (ae.getActionCommand())
		{
		case "Metal": 	look = me; break;
		case "Motif":	look = mo; break;
		case "Windows":	look = wi; break;
		case "Nimbus": 	look = ni; break;		
		}
		
		anzeige.setText(ae.getActionCommand());
		
		try
		{
			UIManager.setLookAndFeel(look);
			SwingUtilities.updateComponentTreeUI(frame);
		}
		catch (Exception e)
		{
			System.err.println(e.getMessage());
		}
	}
}
