package swing03mvc;

import java.awt.event.*;

/**
 * Der Controller muss beide die View und das Model kennen
 * da dieser fr die Kommunikation zwischen den Beiden sorgt
 */
public class Controller
{
	private View view;
	private Model model;

	public Controller()
	{
		this.model 	= new Model();
		this.view	= new View();
		this.addListener();
	}
	
	private void addListener()
	{
		view.setActionListener(new MyActionListener());
		view.setFocusListener(new MyFocusListener());
	}
		
    class MyActionListener implements ActionListener
    {
        public void actionPerformed(ActionEvent ae) 
        {
        	if (ae.getActionCommand() == "Beenden")
        	{
        		System.exit(0);
        	}
        	if (ae.getActionCommand() == "Umrechnen")
        	{
        		String s_kw = view.getKw();
        		String s_ps = view.getPs();
        		float f_kw = 0;
        		float f_ps = 0;
        		
        		if (!s_kw.equals("")) f_kw = Float.valueOf(s_kw); 
        		if (!s_ps.equals("")) f_ps = Float.valueOf(s_ps);
        		
        		model.setPsKw(f_ps, f_kw);
        		model.umrechnen();
        		
        		view.setKw(String.valueOf(model.getKw()));
        		view.setPs(String.valueOf(model.getPs()));
        	}
        }
    }
    
    class MyFocusListener extends FocusAdapter
	{
    	public void focusGained (FocusEvent e)
    	{
    		model.resetModel();
    		view.resetView();
    	}
	}
}
