package swing03mvc;

public class Model
{
	// Konstanten (Umrechnungsfaktoren)
	private final static float PS_TO_KW = 0.73f; 
	private final static float KW_TO_PS = 1.36f;
	
	private float kw;
	private float ps;
	
	public Model ()
	{
		this.resetModel();
	}
	
	public void resetModel()
	{
		kw = 0.0f; ps = 0.0f;
	}
	
	public void umrechnen()
	{
		if (ps == 0.0d)
		{
			ps = kw * KW_TO_PS;
		}
		else
		{
			kw = ps * PS_TO_KW;
		}
	}
	
	public void setPsKw(float ps, float kw)
	{
		this.ps = ps;
		this.kw = kw;
	}
	
	public double getPs()
	{
		return this.ps;
	}
	
	public double getKw()
	{
		return this.kw;
	}
}
