package swing03mvc;

import java.awt.*; 
import java.awt.event.*;
import javax.swing.*;

/* Die View-Klasse enthlt nur die Prsentation
 * hier sollte man keinerlei Programmlogik finden
 * alle Berechnungen und Reaktionen auf Benutzeraktionen
 * sollten allesammt im Controller stehen
 */
public class View 
{
	JFrame frame;
	
	private JTextField 	ps 	= new JTextField ("", 10);
	private JTextField 	kw 	= new JTextField ("", 10);
	private JButton 	um		= new JButton ("Umrechnen");
	private JButton		end		= new JButton ("Beenden");
	private JPanel 		p1 		= new JPanel ();
	private JPanel 		p2 		= new JPanel ();
	
	public View() //Konstruktor
	{
		frame = new JFrame("PS in KW");
		p1.setLayout (new GridLayout(1,4));
		p1.add (ps); p1.add (new JLabel ("=PS"));		
		p1.add (kw); p1.add (new JLabel ("=KW"));		
		p2.setLayout(new BorderLayout());
		p2.add (BorderLayout.CENTER,um);
		p2.add (BorderLayout.LINE_END, end);
		
		Container cp = frame.getContentPane();
		cp.setLayout (new BorderLayout());
		cp.add (BorderLayout.PAGE_START, p1);
		cp.add (BorderLayout.PAGE_END, p2);
		cp.setBackground (Color.lightGray);
		
		frame.setSize (300,100);
		frame.setVisible (true);
	}
	
	//Schnittstelle zu den Textfeldern
	public void resetView()
	{
		this.ps.setText("");
	    this.kw.setText("");
	}
	
	public String getPs()
	{
		return this.ps.getText();
	}
	
	public String getKw()
	{
		return this.kw.getText();
	}
	
	public void setPs(String ps)
	{
		this.ps.setText(ps);
	}
	
	public void setKw(String kw)
	{
		this.kw.setText(kw);
	}	
	
	//Schnittstelle zu den Listenern
    public void setActionListener(ActionListener al)
    {
        this.um.addActionListener(al);
        this.end.addActionListener(al);
    }
    
    public void setFocusListener(FocusListener fl)
    {
        this.ps.addFocusListener(fl);
        this.kw.addFocusListener(fl);
    }
}
