package swing10tableDynamisch;

import java.awt.*;
import java.util.Vector;
import javax.swing.*;

public class ViewTabelle
{
	private JFrame			frame;
	private JTable 			tabelle;
	private JScrollPane 	sp;
	private ModelSpalten 	sd = new ModelSpalten();
	private ModelTabelle	td = new ModelTabelle();
	
	public ViewTabelle()
	{
		frame = new JFrame("Teballe");
		tabelle = new JTable(td, sd);
		tabelle.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		sp = new JScrollPane(tabelle);
		
		//Layout
		Container contentPane = frame.getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(BorderLayout.CENTER, sp);
		
		// Sonstige Fenstereinstellungen
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(300, 100);
		frame.setVisible(true);
	}
	
	public void addZeile (Vector<Object> zeile)
	{
		td.addRow(zeile);
	}
	
	public void addZeile (Object[] zeile)
	{
		td.addRow(zeile);
	}
}
