package thread08gehatSynchronized;

public class Konto
{
	private int gehalt;
	private Schluessel schluessel;
	
	public Konto (int gehalt)
	{
		this.gehalt = gehalt;
		this.schluessel = new Schluessel();
	}
	
	public void einzahlen (int wert)
	{
		synchronized (this.schluessel)
		{
			this.gehalt = this.gehalt + wert;
		}
	}
	
	public void abbuchen (int wert)
	{
		synchronized (this.schluessel)
		{
			this.gehalt = this.gehalt - wert;
		}
	}
	
	public void showGehalt()
	{
		System.out.println("\n Gehalt: " + this.gehalt);
	}
	
	/* Vereinfachung 1
	
	public void einzahlen (int wert)
	{
		synchronized (this)
		{
			this.gehalt = this.gehalt + wert;
		}
	}
	
	public void abbuchen (int wert)
	{
		synchronized (this.schluessel)
		{
			this.gehalt = this.gehalt - wert;
		}
	}
	
	*/
	
	/* Vereinvachung 2
	
	public synchronized void einzahlen (int wert)
	{
		this.gehalt = this.gehalt + wert;
	}
	
	public synchronized void abbuchen (int wert)
	{
		this.gehalt = this.gehalt - wert;
	}
	
	*/	
	
}
