/*
* 07:19:51
* vjanssen
*/
package xml01;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

public class Start
{
	static String xmlDokument = "src/xml01/Grafik.xml";
	static String xmlSchema = "src/xml01/Grafik.xsd";

	public static void main(String[] args)
	{
		try
		{
			// Schema s bestimmen und einlesen
			SchemaFactory sF = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Source sS = new StreamSource(new File(xmlSchema));
			Schema s = sF.newSchema(sS);

			// Dokument d gegen s prfen und einlesen
			DocumentBuilderFactory dF = DocumentBuilderFactory.newInstance();
			dF.setNamespaceAware(true); 
			dF.setSchema(s);
			DocumentBuilder dB = dF.newDocumentBuilder();
			Document d = dB.parse(xmlDokument);
			d.getDocumentElement().normalize();

			// XML-Dokument auswerten
			String root = d.getDocumentElement().getNodeName();
			System.out.println("Root Element :" + root + "\n=====================");

			// Liste aller Texte anlegen
			NodeList l = d.getElementsByTagName("text");
			for (int i = 0; i < l.getLength(); i++)
			{
				Node n 			= l.item(i);
				Element e 	= (Element) n;
				// Test auslesen
				String wert 		= e.getTextContent();
				// Attribute bestimmen
				String x 			= e.getAttribute("x");
				String y 			= e.getAttribute("y");
				String farbe 		= e.getAttribute("farbe");

				System.out.print("Text:" + wert);
				System.out.println(" / Attribute"
				 + " x=" + x
				 + " y=" + y 
				 + " Farbe=" + farbe);
			}

			// Alle Grafikelemente bestimmen 
			l = d.getElementsByTagName("grafik");
			for (int i = 0; i < l.getLength(); i++)
			{
				Node n 			= l.item(i);
				Element e 	= (Element) n;
				// Grafikattribute auslesen
				String x 			= e.getAttribute("x");
				String y 			= e.getAttribute("y");
				String b 		= e.getAttribute("breite");
				String fa	 	= e.getAttribute("farbe");
				String fo 		= e.getAttribute("form");
				
				System.out.print("Grafik:");
				System.out.println(" / Attribute"  
				 + " x=" + x 
				 + " y=" + y 
				 + " Breite=" + b 
				 + " Farbe=" + fa 
				 + " Form=" + fo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
