package a0215_u_Kreissegment;

import java.awt.Color;
import java.awt.Graphics2D;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;

	public void meinProgramm (
		String[]	args,			// Programm Aufrufparameter
		Graphics2D 	g, 				// Universelles Zeichenobjekt
		int			eingabeIndex,	// Index der Eingabe
		String 		sEingabe, 		// Eingabe als Zeichenkette
		char 		cEingabe, 		// Erstes Zeichen der Eingabe
		double 		dEingabe, 		// Eingabe als Gleitkommazahl (wenn mglich!)
		int 		iEingabe)		// Eingabe als ganze Zahl (wenn mglich!)
	{
		int aPos = 1;				// Anzahl der geschnittenen Kuchenstcke
		int vPos = 1;				// Anzahl noch vorhandener Kuchenstcke
		
		print("Stcke geschnitten (1-20): ");
		if (eingabeIndex >= 0) 		// 1. Eingebe vorhanden
		{
			aPos 	= _Eingabe.getInt(0); 		// Anzahl der geschnittenen Kuchenstcke
			println(aPos);
			print("Stcke vorhanden   (1-"+aPos+"): " );
		}
		if (eingabeIndex >= 1) 		// 2. Eingebe vorhanden
		{
			println(_Eingabe.getInt(1));			
			vPos 	= _Eingabe.getInt(1); 		// Anzahl noch vorhandener Kuchenstcke
			
			if (	aPos < 1 || aPos > 20
				||	vPos < 1 || vPos > aPos)
			{
				print("Eingabefehler");
			}
			else
			{
				int xPos1	= 100;					// x-Position
				int xPos2 	= 250;					// x-Position
				int yPos 	= 100; 					// y-Position
				int dPos 	= 100; 					// Duchmesser
				int rPos 	= 50; 					// Radius
				
				int winkelSchritt = 360 / aPos;
				for (int i=0; i<vPos; i++)
				{
					// gefllte Kreissehmente mit Farbwechsel ROT und BLAU 
					int startWinkel = i * winkelSchritt;
					if(i%2==0)	g.setColor(Color.RED);
					else		g.setColor(Color.BLUE);
					g.fillArc(xPos1, yPos, dPos, dPos, startWinkel, winkelSchritt);
					
					// einhetlich gelbe Kreissegmente mit schwarzen Auenlinien
					g.setColor(Color.YELLOW);
					g.fillArc(xPos2, yPos, dPos, dPos, startWinkel, winkelSchritt);
					g.setColor(Color.BLACK);
					g.drawArc(xPos2, yPos, dPos, dPos, startWinkel, winkelSchritt);
				}
				
				// Linie Zeichnen und das Gesamte Koordinatensystem am Mittelpunkt rotieren lassen
				for (int i=0; i<vPos+1; i++)
				{	
					// Trennlinien Zeichnen
					g.drawLine(xPos2+rPos, yPos+rPos, xPos2+dPos, yPos+rPos);
					g.rotate(-Math.toRadians(winkelSchritt), xPos2+rPos, yPos+rPos);				
				}
				
				// Rotation des Koordinatensystems zurcknehmen
				for (int i=0; i<vPos+1; i++)
				{					
					g.rotate(Math.toRadians(winkelSchritt), xPos2+rPos, yPos+rPos);				
				}
			}
		}
	}
}
