package a0223_u_PasswortTest;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Scanner;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;

	public void meinProgramm (
		String[]	args,			// Programm Aufrufparameter
		Graphics2D 	g, 				// Universelles Zeichenobjekt
		int			eingabeIndex,	// Index der Eingabe
		String 		sEingabe, 		// Eingabe als Zeichenkette
		char 		cEingabe, 		// Erstes Zeichen der Eingabe
		double 		dEingabe, 		// Eingabe als Gleitkommazahl (wenn mglich!)
		int 		iEingabe)		// Eingabe als ganze Zahl (wenn mglich!)
	{
		
		println("Geben Sie ein Passwort ein: " + sEingabe);
		
		String pwd = sEingabe; 		 
		
		int 	bi 	= -1;				// Index des Vorgngerbuchstaben
		boolean	bOk	= false;			// wird true wenn Buchstabenblock unterbrochen
		
		int 	zi	= -1;				// Index der vorgngerziffer
		boolean zOk	= false;			// wird true wenn Ziffernblock unterbrochen 
		
		int 	sonder	= 0;			// Anzahl an Sonderzeichen	
		int 	gross	= 0;			// Anzahl an Grobuchstaben
		int 	klein	= 0; 			// Anzahl an Kleinbuchstaben
		int 	zahl	= 0;			// Anzahl gefundener Ziffern
		
		for (int i=0; i< pwd.length(); i++)
		{
			char 	c 	= pwd.charAt(i);
						
			if (isZahl(c))			 	
			{
				if (zi != -1) 					// Es existiert Vorgnger
				{
					if (zi < i-1) zOk = true; 	// Vorgnger hat Abstand -> KEIN Zahlenblock	
				}
				zi = i;							// Index speichern
				zahl 	= zahl		+1;			// Zahl gefunden
			}
			if (isBuchstabe(c))			 	
			{
				if (bi != -1)					// Es existiert Vorgnger
				{
					if (bi < i-1) bOk = true; 	// Vorgnger hat Abstand -> KEIN Buchstabenblock
				}				
				bi = i;							// Index speichern
			}
			if (isGrossBuchstabe(c)) 	gross	= gross		+1;		// Grobuchstabe gefunden
			if (isKleinBuchstabe(c)) 	klein	= klein		+1;		// Kleinbuchstabe gefunden
			if (isSonderzeichen(c)) 	sonder 	= sonder	+1;		// Sonderzeichen gefunden
		}
		
		int pwdOK = 0; 					// ist 0 wenn Passwort OK sinst Anzahl der Bedingungen die verletzt werden
		
		if (pwd.length() 	< 8) 	
		{
			println("-> Passwort hat weniger als 8 Zeichen!");
			pwdOK = pwdOK +1;		// NICHT midestens 8 Zeichen
		}
		if (gross + klein 	< 3)	
		{
			println("-> Passwort hat weniger als 3 Buchstaben");
			pwdOK = pwdOK +1;		// NICHT midestens 3 Buchstaben
		}
		if (zahl 	<  3)
		{
			println("-> Passwort hat weniger als 3 Ziffern");
			pwdOK = pwdOK +1;		// NICHT midestens 3 Zahlen
		}
		if (sonder 	== 0)
		{
			println("-> Passwort enthlt KEIN Sonderzeichen");
			pwdOK = pwdOK +1;		// NICHT mindestens ein Sonderzeichen
		}
		if (gross 	== 0)
		{
			println("-> Passwort enthlt KEINEN Grobuchstaben");
			pwdOK = pwdOK +1;		// NICHT midestens 1 Grobuchstabe
		}
		if (klein 	== 0)
		{
			println("-> Passwort enthlt KEINEN Kleinbuchstaben");
			pwdOK = pwdOK +1;		// NICHT midestens 1 Kleinbuchstabe
		}
		if (!zOk)
		{
			println("-> Passwort enthlt Zahlenblock");
			pwdOK = pwdOK +1;		// Zahlenblock NICHT unterbrochen
		}
		if (!bOk)					
		{
			println("-> Passwort enthlt Buchstabenblock");
			pwdOK = pwdOK +1;		// Buchstabenblock NICHT unterbochen	
		}
		
		if (pwdOK == 0) 
		{
			println("Das Passwort ist OK!");
			showAmpel(g, 200, 250, 'g');
		}
		else 			
		{
			println("Anzahl missachteter Regeln: " + pwdOK );
			showAmpel(g, 200, 250, 'r');
		}
	}
	
	public static boolean isSonderzeichen(char c)
	{
		String sz = "!$%&/()=?+*#'-";	// Sonderzeichen
		if (sz.indexOf(c) == -1) 	return false;
		else					 	return true;
	}
	
	public static boolean isZahl(char c)
	{
		String sz = "0123456789";	// Sonderzeichen
		if (sz.indexOf(c) == -1) 	return false;
		else					 	return true;
	}
	
	public static boolean isGrossBuchstabe(char c)
	{
		int unicode = (int)c;
		if (unicode >= 65 && unicode <= 90) 	return true;
		else									return false;
	}
	
	public static boolean isKleinBuchstabe(char c)
	{
		int unicode = (int)c;
		if (unicode >= 97 && unicode <= 122) 	return true;
		else									return false;
	}
	
	public static boolean isBuchstabe(char c)
	{
		if (isGrossBuchstabe(c) || isKleinBuchstabe(c)) return true;
		else											return false;
	}
	
	public static void showAmpel(Graphics2D g, int x, int y, char wert)
	{
		int xAmpel = x;		// x-Position
		int yAmpel = y;		// y-Position
		int bAmpel = 50;	// Breite 
		int aAmpel = 10;	// Abstand 
		
		if (wert == 'r')
		{
			g.setColor(Color.RED);
			g.fillOval(xAmpel+aAmpel, yAmpel+aAmpel, bAmpel, bAmpel);
		}
		else
		{
			g.setColor(Color.GREEN);
			g.fillOval(xAmpel+aAmpel, yAmpel+bAmpel+aAmpel+aAmpel, bAmpel, bAmpel);
		}
		
		g.setColor(Color.BLACK);
		g.drawRect(xAmpel, yAmpel, bAmpel+aAmpel+aAmpel, (bAmpel+aAmpel)*2+aAmpel);
		g.drawOval(xAmpel+aAmpel, yAmpel+aAmpel, bAmpel, bAmpel);
		g.drawOval(xAmpel+aAmpel, yAmpel+bAmpel+aAmpel+aAmpel, bAmpel, bAmpel);		
	}
}
