package a0225_u_ISBN;

import java.awt.Color;
import java.awt.Graphics2D;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;

	public void meinProgramm (
		String[]	args,			// Programm Aufrufparameter
		Graphics2D 	g, 				// Universelles Zeichenobjekt
		int			eingabeIndex,	// Index der Eingabe
		String 		sEingabe, 		// Eingabe als Zeichenkette
		char 		cEingabe, 		// Erstes Zeichen der Eingabe
		double 		dEingabe, 		// Eingabe als Gleitkommazahl (wenn mglich!)
		int 		iEingabe)		// Eingabe als ganze Zahl (wenn mglich!)
	{
		String zahlen 	= "0123456789";
		String isbn 	= "";

		// Eingabekontrolle und Korrektur
		println("Eingabe: " + sEingabe );
		for (int i=0; i<sEingabe.length(); i++)
		{
			char z = sEingabe.charAt(i);
			
			if (zahlen.indexOf(z) != -1)
			{
				isbn = isbn + z; 
			}
		}
		println("ISBN: " + isbn);
		
		boolean isbnOk = false;
		
		if (isbn.length() == 13)
		{
			String 	p = isbn.substring(0, 3);	// Prfix
			char 	l = isbn.charAt(3);			// Lnderkennung
					
			println("Prfix " 			+ p );
			println("Lnderkennung: " 	+ l );
			
			if (p.equals("978") || p.equals("979"))
			{
				if (l == '3')
				{
					int erg = 0;
				
					for (int i=0; i<isbn.length(); i++)
					{
						int z = zahlen.indexOf(isbn.charAt(i));
						
						if (i%2==0)	erg = erg + z;		// gerader Index -> ungerade Position
						else		erg = erg + 3*z;	// ungerader Index -> gerade Position
					}				
					if (erg%10 == 0) isbnOk = true;				
				}
			}
		}
		if (isbnOk)	
		{
			println("ISBN ist zulssig \nim deutschsprachigen Raum");
			showAmpel(g, 200, 250, 'g');
		}
		else
		{
			println("ISBN ist NICHT zulssig \nim deutschsprachigen Raum");
			showAmpel(g, 200, 250, 'r');
		}
	}
	
	public static void showAmpel(Graphics2D g, int x, int y, char wert)
	{
		int xAmpel = x;		// x-Position
		int yAmpel = y;		// y-Position
		int bAmpel = 50;	// Breite 
		int aAmpel = 10;	// Abstand 
		
		if (wert == 'r')
		{
			g.setColor(Color.RED);
			g.fillOval(xAmpel+aAmpel, yAmpel+aAmpel, bAmpel, bAmpel);
		}
		else
		{
			g.setColor(Color.GREEN);
			g.fillOval(xAmpel+aAmpel, yAmpel+bAmpel+aAmpel+aAmpel, bAmpel, bAmpel);
		}
		
		g.setColor(Color.BLACK);
		g.drawRect(xAmpel, yAmpel, bAmpel+aAmpel+aAmpel, (bAmpel+aAmpel)*2+aAmpel);
		g.drawOval(xAmpel+aAmpel, yAmpel+aAmpel, bAmpel, bAmpel);
		g.drawOval(xAmpel+aAmpel, yAmpel+bAmpel+aAmpel+aAmpel, bAmpel, bAmpel);		
	}

}
