package a0227_u_Schach;

import java.awt.Color;
import java.awt.Graphics2D;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;

	public void meinProgramm (
		String[]	args,			// Programm Aufrufparameter
		Graphics2D 	g, 				// Universelles Zeichenobjekt
		int			eingabeIndex,	// Index der Eingabe
		String 		sEingabe, 		// Eingabe als Zeichenkette
		char 		cEingabe, 		// Erstes Zeichen der Eingabe
		double 		dEingabe, 		// Eingabe als Gleitkommazahl (wenn mglich!)
		int 		iEingabe)		// Eingabe als ganze Zahl (wenn mglich!)
	{
		char[][] stellung = 
			{
					{'t', 'b', ' ', ' ', ' ', ' ', 'B', 'T'},
					{'s', 'b', ' ', ' ', ' ', ' ', 'B', 'S'},
					{'l', 'b', ' ', ' ', ' ', ' ', 'B', 'L'},
					{'d', 'b', ' ', ' ', ' ', ' ', 'B', 'D'},
					{'k', 'b', ' ', ' ', ' ', ' ', 'B', 'K'},
					{'l', 'b', ' ', ' ', ' ', ' ', 'B', 'L'},
					{'s', 'b', ' ', ' ', ' ', ' ', 'B', 'S'},
					{'t', 'b', ' ', ' ', ' ', ' ', 'B', 'T'},
			};
		
		for (int i=0; i<=eingabeIndex; i++)
		{
			String zug = _Eingabe.getString(i);
					
			if (ziehen(zug, stellung))	println(zug);
			else						_Eingabe.removeEingabe(i);
		}
		
		showStellung(g, stellung);
	}
	
	public static boolean ziehen(String zug, char[][]stellung)
	{
		zug = zug.toLowerCase();
		String buchstaben	= "abcdefgh";
		String zahlen     	= "12345678";
		
		zug.trim();							// Zhrende Leerzeichen entfernen
		zug.replace("  +", " ");			// Leerzeichen in der Eingabe entfernen
		
		if (zug.length() == 5)
		{
			int xAnfang = buchstaben.indexOf(zug.charAt(0));
			int yAnfang = zahlen.indexOf(zug.charAt(1));
			int xEnde 	= buchstaben.indexOf(zug.charAt(3));
			int yEnde	= zahlen.indexOf(zug.charAt(4));
		
			if (	xAnfang != -1			// Buchstabe aus abcdefgh
				&&	yAnfang != -1			// Zahl aus 12345678
				&& 	zug.charAt(2) == '-'	// Trennstrich '-'
				&& 	xEnde	!= -1			// Buchstabe aus abcdefgh
				&&	yEnde	!= -1	)		// Zahl aus 12345678
			{
				if (stellung[xAnfang][yAnfang] != ' ')
				{
					// Figur auf neues Feld ziehen
					stellung[xEnde][yEnde] = stellung[xAnfang][yAnfang];
					// Figur von altem Feld lschen
					stellung[xAnfang][yAnfang] = ' ';
					// Eingabe OK und Zug ausgefhrt
					return true; 			
				}
			}
		}
		return false;
	}
	
	public static void showStellung(Graphics2D g, char[][] stellung)
	{
		int xPos = 120;
		int yPos = 50;
		int bPos = 40;
		int aPos = 3;
		
		String weiss 		= "bstldkb";			// weie Figuren b = Bauer, s = Springer ... 
		String schwarz 		= "BSTLDKB";			// schwarze Figuren B = Bauer, S = Springer, ...
		String buchstaben 	= "abcdefgh";
				
		for (int i=0; i<stellung.length; i++)
		{
			g.setColor(Color.BLACK);
			g.drawString(""+buchstaben.charAt(i), xPos + i*bPos + 5*aPos, yPos-5*aPos);
			g.drawString(""+(i+1), xPos - 5*aPos, yPos + i*bPos + 5*aPos);
			
			for (int j=0; j<stellung[i].length; j++)
			{
				int x = xPos + i*bPos;
				int y = yPos + j*bPos;
				
				if ((i+j)%2 == 0) 	g.setColor(Color.GRAY);
				else				g.setColor(Color.LIGHT_GRAY);
				g.fill3DRect(x, y, bPos, bPos, true);	
				
				char z = stellung[i][j];
				
				if (schwarz.indexOf(z) != -1)
				{
					g.setColor(Color.DARK_GRAY);
				}
				if (weiss.indexOf(z) != -1)
				{
					g.setColor(Color.WHITE);
					// Umwandeln in Grobuchstabe (Zusatzaufgabe)
					z=schwarz.charAt(weiss.indexOf(z));
				}				
				
				if (z != ' ')
				{
					g.fillOval(x + aPos , y + aPos, bPos-2*aPos, bPos-2*aPos);
					g.setColor(Color.RED);
					g.drawString(""+z, x + aPos*5, y + aPos*8);
				}
				
			}
		}
	}
}
