package a0305_u_Funktionsgraph;

import java.awt.Color;
import java.awt.Graphics2D;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;

	public void meinProgramm (
		String[]	args,			// Programm Aufrufparameter
		Graphics2D 	g, 				// Universelles Zeichenobjekt
		int			eingabeIndex,	// Index der Eingabe
		String 		sEingabe, 		// Eingabe als Zeichenkette
		char 		cEingabe, 		// Erstes Zeichen der Eingabe
		double 		dEingabe, 		// Eingabe als Gleitkommazahl (wenn mglich!)
		int 		iEingabe)		// Eingabe als ganze Zahl (wenn mglich!)
	{
		// Koordinaten des Koordinatenursprings (Verschiebungswerte)
		int xKo = 240;
		int yKo = 220;
		
		koordinatensystem(g, xKo, yKo);
		funktionsgraph(g, xKo, yKo, sEingabe);		
	}
	
	public static void funktionsgraph(Graphics2D g, int xKo, int yKo, String funktion)
	{
		g.setColor(Color.RED);
		
		int xPosAlt = 501; // Auerhab des Zeichenbereiches
		int yPosAlt = 501;
		int xPosNeu = 501;
		int yPosNeu = 501;
		
		for (double x=-5; x<=+5; x=x+0.01d)
		{
			double y = 0;
			
			switch(funktion)
			{
				case "sin": 	y = Math.sin(x);	break;
				case "asin": 	y = Math.asin(x);	break;
				case "cos": 	y = Math.cos(x);	break;
				case "acos": 	y = Math.acos(x);	break;
				case "cosh": 	y = Math.cosh(x);	break;
				case "tan": 	y = Math.tan(x);	break;
				case "atan": 	y = Math.atan(x);	break;
				case "exp": 	y = Math.exp(x);	break;
				case "log": 	y = Math.log(x);	break;
				case "cbrt": 	y = Math.cbrt(x);	break;
				case "ceil": 	y = Math.ceil(x);	break;
				case "sqrt": 	y = Math.sqrt(x);	break;
				default:		y = 5.01; // Auerhab des Zeichenbereiches		
			}
			
			xPosNeu = (int) (x*100);
			yPosNeu = (int) (y*-100);
			
			// Linie nur zeichnen wenn beide Punkte im Zeichenbereich
			if ( 	xPosNeu > -500 && xPosNeu < 500 
				&& 	xPosAlt > -500 && xPosAlt < 500
				&& 	yPosNeu > -500 && yPosNeu < 500 
				&& 	yPosAlt > -500 && yPosAlt < 500	)
			g.drawLine(xKo+xPosNeu,  yKo+yPosNeu,  xKo+xPosAlt,  yKo+yPosAlt);

			//g.drawOval(xKo+xPos, yKo+yPos, 1, 1);	
			
			xPosAlt = xPosNeu;
			yPosAlt = yPosNeu;			
		}
	}
	
	public static void koordinatensystem(Graphics2D g, int xKo, int yKo)
	{
		g.setColor(Color.BLACK);
		g.drawLine(xKo-500, yKo, xKo+500, yKo);
		g.drawLine(xKo, yKo-500, xKo, yKo+500);
		
		for (int i=xKo-500; i<=xKo+500; i=i+10)
		{
			g.drawLine(i, yKo-3, i, yKo+3);
			if ((i-xKo)%100==0) g.drawString(Integer.toString((i-xKo) / 100), i-5, yKo+15);
		}
		
		for (int i=yKo-500; i<=yKo+500; i=i+10)
		{
			g.drawLine(xKo-3, i, xKo+3, i);
			if ((i-yKo)%100==0) g.drawString(Integer.toString((i-yKo) / -100), xKo-15, i+5);
		}		
	}
}
