/*
* 08:52:01
* vjanssen
*/
package a0404b_u_Wuerfel_Teil3;

import java.awt.Color;
import java.awt.Graphics2D;

public class Wuerfel
{
	// Klassenvariablen
	private static Color standardFarbe	= Color.BLACK;
	
	// Klassenmethoden
	public static void setStandardFarbe(Color farbe)
	{
		Wuerfel.standardFarbe = farbe;
	}
	
	// Objektvariablen
	private int xPos;
	private int yPos;
	private Color farbe;
	private int wert;
	private boolean gueltig;
	
	// Konstruktoren
	public Wuerfel()
	{
		this(50,50, Wuerfel.standardFarbe);
	}
	
	public Wuerfel(int xPos, int yPos)
	{
		this(xPos, yPos, Wuerfel.standardFarbe);
	}
	
	public Wuerfel(int xPos, int yPos, Color farbe)
	{
		// vernderbare Werte
		this.xPos = xPos;
		this.yPos = yPos;
		this.farbe = farbe;
		// feste Werte
		this.wuerfeln();
		this.gueltig=true;		
	}
	
	// Objektmethoden
	public void wuerfeln()
	{
		this.wert = (int) (Math.random()*6+1);
	}
	
	public void gueltig()
	{
		this.gueltig = true;
	}
	
	public boolean getGueltig()
	{
		return this.gueltig;
	}
	
	public void ungueltig()
	{
		this.gueltig = false;
	}
	
	public int getWert()
	{
		return this.wert;
	}
	
	public void showObjektVar()
	{
		System.out.print("Wurf: " + this.wert);
		if (this.gueltig)	System.out.println(" / gltig");
		else				System.out.println(" / ungltig");
	}
	
	public void drawObjekt(Graphics2D g)
	{
		int p = 10; 	// Breite Punkt
		int a = 2; 		// Abstand zwischen Punkten 
		int b = 38;		// Breite des Wrfels
		int w = 10;  	// Winkel
		
		g.setColor(this.farbe);
		g.fillRoundRect(this.xPos, this.yPos, b, b, w, w);
		
		g.setColor(Color.WHITE);
		if (this.wert>1)	g.fillOval(this.xPos+a		, this.yPos+a		, p, p);
		if (this.wert>3) 	g.fillOval(this.xPos+3*a+2*p, this.yPos+a		, p, p);
		if (this.wert>5)	g.fillOval(this.xPos+a		, this.yPos+2*a+p	, p, p);
		if (this.wert%2==1) g.fillOval(this.xPos+2*a+p	, this.yPos+2*a+p	, p, p);
		if (this.wert>5)	g.fillOval(this.xPos+3*a+2*p, this.yPos+2*a+p	, p, p);
		if (this.wert>3)	g.fillOval(this.xPos+a		, this.yPos+3*a+2*p	, p, p);
		if (this.wert>1) 	g.fillOval(this.xPos+3*a+2*p, this.yPos+3*a+2*p	, p, p);
		
		g.setColor(Color.BLACK);
		if (!this.gueltig)	
		{
			g.setColor(Color.RED);
			g.fillRect(this.xPos-a*2, this.yPos+b/2-a*2, b+2*a*2, 2*a*2);
			g.setColor(Color.BLACK);
			g.drawRect(this.xPos-a*2, this.yPos+b/2-a*2, b+2*a*2, 2*a*2);
		}
	}
}
