/*
* 14:25:54
* vjanssen
*/
package a0404c_k_Patient_Teil3;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class Patient
{
	// Klassenvariablen
	private static int anzahlPatienten = 0;
	private static int anzahlKranke = 0;
	
	// Klassenmethoden
	public static void showAnzahl()
	{
		System.out.println("----- Anzahl -----");
		System.out.println("Patienten: " + Patient.anzahlPatienten);
		System.out.println("Kranke:    " + Patient.anzahlKranke);
	}
	
	// Objektvariablen
	private String vorname;
	private String nachname;
	private char geschlecht;
	private int geburtsjahr;
	private double groesse;
	private double gewicht;
	private boolean krank;
	
	public Patient()
	{
		this ("Eva", "Klein", 'w', 2001, 1.55d, 53.0d, false);
	}
	
	public Patient(String vorname, String nachname, char geschlecht, int geburtsjahr, double groesse, double gewicht, boolean krank)
	{
		this.vorname = vorname;
		this.nachname = nachname;
		this.geschlecht = geschlecht;
		this.geburtsjahr = geburtsjahr;
		this.groesse = groesse;
		this.gewicht = gewicht;
		this.setKrank(krank);
		
		Patient.anzahlPatienten++;
	}
	
	public int alter()
	{
		Calendar cal = new GregorianCalendar();
		int jahr = cal.get(Calendar.YEAR);
		
		return jahr - this.geburtsjahr;
	}
	
	public void setGroesse(double groesse)
	{
		this.groesse = groesse;
	}
	
	public void setGewicht(double gewicht)
	{
		this.gewicht = gewicht;
	}
	
	public void setKrank(boolean krank)
	{
		if (this.krank != krank)		// Zustand ndert sich
		{
			this.krank = krank;
			if (krank)	Patient.anzahlKranke++;		// erkrankt
			else		Patient.anzahlKranke--;		// genesen
		}		
	}
	
	public double getGroesse()
	{
		return this.groesse;
	}
	
	public double getGewicht()
	{
		return this.groesse;
	}

	public boolean getKranke()
	{
		return this.krank;
	}
	
	public void showObjektVar()
	{
		System.out.println("----- Patient -----");
		System.out.println("Vorname:     " + this.vorname);
		System.out.println("Nachname:    " + this.nachname);
		System.out.println("Geschlecht:  " + this.geschlecht);
		System.out.println("Geburtsjahr: " + this.geburtsjahr);
		System.out.println("Alter:       " + this.alter());
		System.out.println("Groesse:     " + this.groesse);
		System.out.println("Gewicht:     " + this.gewicht);
		if (this.krank)	System.out.println("-> Krank");
		else			System.out.println("-> Gesund");
	}
	
	protected void finalize()
	{
		Patient.anzahlPatienten--;
		if (this.krank) Patient.anzahlKranke--;
	}
}
