/*
* 09:09:37
* vjanssen
*/
package a0502c_u_Wuerfel_Komposition;

import java.awt.Color;
import java.awt.Graphics2D;

public class Wurf
{
	private Wuerfel[] wuerfel = new Wuerfel[5];
	private int anzahlWuerfe;
		
	public Wurf()
	{
		this(50);
	}
	
	public Wurf(int yPos)
	{
		this.anzahlWuerfe = 1;
		
		int xPos = 0;
		for (int i=0; i<this.wuerfel.length; i++)
		{
			xPos = xPos + 50;
			this.wuerfel[i] = new Wuerfel(xPos, yPos);
		}
	}
	
	public void setYPos(int yPos)
	{
		for (int i=0; i<this.wuerfel.length; i++)
		{
			this.wuerfel[i].setYPos(yPos);
		}
		
	}
	
	public void drawObjekt(Graphics2D g)
	{

		int yPos = this.wuerfel[0].getYPos();
		
		g.drawString("Wurf " + this.anzahlWuerfe, 10, yPos+20);
		
		for (int i=0; i<this.wuerfel.length; i++)
		{
			this.wuerfel[i].drawObjekt(g);
		}		
	}
	
	public void wuerfeln()
	{
		this.anzahlWuerfe++;
		
		for (int i=0; i<this.wuerfel.length; i++)
		{
			if (!this.wuerfel[i].getGueltig())
			{
				this.wuerfel[i].wuerfeln();
				this.wuerfel[i].gueltig();
			}
		}
	}
	
	public void ungueltig(int index)
	{
		if (index > 0 && index < this.wuerfel.length)
		{
			this.wuerfel[index].ungueltig();
		}
	}
	
	public void gueltig(int index)
	{
		if (index > 0 && index < this.wuerfel.length)
		{
			this.wuerfel[index].gueltig();
		}
	}
	
	public int getAnzahlGueltig()
	{
		int anzahl = 0;
		
		for (int i=0; i<this.wuerfel.length; i++)
		{
			if (this.wuerfel[i].getGueltig()) anzahl++;
		}
		
		return anzahl;
	}
	
	public int getAnzalWuerfe()
	{
		return this.anzahlWuerfe;
	}
	
	private static class Wuerfel
	{
		private int xPos;
		private int yPos;
		private Color farbe;
		private int wert;
		private boolean gueltig;
		
		public Wuerfel()
		{
			this(50,50,Color.BLACK);
		}
		
		public Wuerfel(int xPos, int yPos)
		{
			this(xPos, yPos, Color.BLACK);
		}
		
		public void setYPos(int yPos)
		{
			this.yPos = yPos;
		}
		
		public int getYPos()
		{
			return this.yPos;
		}
		
		public Wuerfel(int xPos, int yPos, Color farbe)
		{
			// vernderbare Werte
			this.xPos = xPos;
			this.yPos = yPos;
			this.farbe = farbe;
			// feste Werte
			this.wuerfeln();
			this.gueltig=true;		
		}
		
		public void wuerfeln()
		{
			this.wert = (int) (Math.random()*6+1);
		}
		
		public void gueltig()
		{
			this.gueltig = true;
		}
		
		public boolean getGueltig()
		{
			return this.gueltig;
		}
		
		public void ungueltig()
		{
			this.gueltig = false;
		}
		
		public int getWert()
		{
			return this.wert;
		}
		
		public void showObjektVar()
		{
			System.out.print("Wurf: " + this.wert);
			if (this.gueltig)	System.out.println(" / gltig");
			else				System.out.println(" / ungltig");
		}
		
		public void drawObjekt(Graphics2D g)
		{
			int p = 10; 	// Breite Punkt
			int a = 2; 		// Abstand zwischen Punkten 
			int b = 38;		// Breite des Wrfels
			int w = 10;  	// Winkel
			
			g.setColor(this.farbe);
			g.fillRoundRect(this.xPos, this.yPos, b, b, w, w);
			
			g.setColor(Color.WHITE);
			if (this.wert>1)	g.fillOval(this.xPos+a		, this.yPos+a		, p, p);
			if (this.wert>3) 	g.fillOval(this.xPos+3*a+2*p, this.yPos+a		, p, p);
			if (this.wert>5)	g.fillOval(this.xPos+a		, this.yPos+2*a+p	, p, p);
			if (this.wert%2==1) g.fillOval(this.xPos+2*a+p	, this.yPos+2*a+p	, p, p);
			if (this.wert>5)	g.fillOval(this.xPos+3*a+2*p, this.yPos+2*a+p	, p, p);
			if (this.wert>3)	g.fillOval(this.xPos+a		, this.yPos+3*a+2*p	, p, p);
			if (this.wert>1) 	g.fillOval(this.xPos+3*a+2*p, this.yPos+3*a+2*p	, p, p);
			
			g.setColor(Color.BLACK);
			if (!this.gueltig)	
			{
				g.setColor(Color.RED);
				g.fillRect(this.xPos-a*2, this.yPos+b/2-a*2, b+2*a*2, 2*a*2);
				g.setColor(Color.BLACK);
				g.drawRect(this.xPos-a*2, this.yPos+b/2-a*2, b+2*a*2, 2*a*2);
			}
		}
	}
}
