/*
* 07:29:45
* vjanssen
*/
package a0503b_u_Kuchen_Teil6;

import java.awt.Color;
import java.awt.Graphics2D;

public class Kuchen
{
	private int xPos;
	private int yPos;
	private int mehl;		// in g
	private int butter;		// in g
	private int eier;		// in Stcke
	private int zucker;		// in g
	private boolean teig;
	private int stueckeGesamt;
	private int stueckeVorhanden;
	
	public Kuchen()
	{
		this(20, 20, 300, 200, 3, 150, 12);
	}
	
	public Kuchen(int xPos, int yPos, int mehl, int butter, int eier, int zucker, int stueckeGesamt)
	{
		// Feste Startwerte
		this.teig = true;
		this.stueckeVorhanden = stueckeGesamt;
		// Einstellbare Werte
		this.xPos = xPos;
		this.yPos = yPos;
		this.mehl = mehl;
		this.butter = butter;
		this.eier = eier;
		this.zucker = zucker;
		this.stueckeGesamt = stueckeGesamt;
	}
	
	public int getXPos()
	{
		return this.xPos;
	}
	
	public int getYPos()
	{
		return this.yPos;
	}	
	
	public void backen()
	{
		this.teig = false;
	}
	
	public void essen (int anzahl)
	{
		if (anzahl < stueckeVorhanden)
		{
			this.stueckeVorhanden = this.stueckeVorhanden - anzahl;	
		}			
	}
	
	public void showObjektVar()
	{
		System.out.println("----- Kuchen -----");
		System.out.println("Mehl:   " + this.mehl);
		System.out.println("Butter: " + this.butter);
		System.out.println("Eier:   " + this.eier);
		System.out.println("zucker: " + this.zucker);
		if (this.teig)	System.out.println("-> Noch Teig");
		else			System.out.println("-> Schon Kuchen");
		System.out.println("Gesamtstcke: " + this.stueckeGesamt);
		System.out.println("Noch vorhandene Stcke : " + this.stueckeVorhanden);		
	}
	
	public void drawObjekt(Graphics2D g)
	{
		int dPos 	= 100; 					// Duchmesser
		int rPos 	= 50; 					// Radius
		int abstand	= 12;					// Abstand
		
		int winkelSchritt = 360 / this.stueckeGesamt;
		for (int i=0; i<this.stueckeVorhanden; i++)
		{
			int startWinkel = i * winkelSchritt;
			// einhetlich gelbe Kreissegmente mit schwarzen Auenlinien
			g.setColor(Color.YELLOW);
			g.fillArc(this.xPos, this.yPos, dPos, dPos, startWinkel, winkelSchritt);
			g.setColor(Color.BLACK);
			g.drawArc(this.xPos, this.yPos, dPos, dPos, startWinkel, winkelSchritt);
		}
		
		// Linie Zeichnen und das Gesamte Koordinatensystem am Mittelpunkt rotieren lassen
		for (int i=0; i<this.stueckeVorhanden+1; i++)
		{	
			// Trennlinien Zeichnen
			g.drawLine(this.xPos+rPos, this.yPos+rPos, this.xPos+dPos, this.yPos+rPos);
			g.rotate(-Math.toRadians(winkelSchritt), this.xPos+rPos, this.yPos+rPos);				
		}
		
		// Rotation des Koordinatensystems zurcknehmen
		for (int i=0; i<stueckeVorhanden+1; i++)
		{					
			g.rotate(Math.toRadians(winkelSchritt), this.xPos+rPos, this.yPos+rPos);				
		}
		g.drawString("Mehl:   " + this.mehl	, this.xPos, this.yPos+dPos+2*abstand);
		g.drawString("Butter: " + this.butter	, this.xPos, this.yPos+dPos+3*abstand);
		g.drawString("Eier:   " + this.eier	, this.xPos, this.yPos+dPos+4*abstand);
		g.drawString("Zucker: " + this.zucker	, this.xPos, this.yPos+dPos+5*abstand);
		String ausgabe;
		if (this.teig) 	ausgabe = "-> Noch Teig";
		else			ausgabe = "-> Schon Kuchen";
		g.drawString(ausgabe	, this.xPos, this.yPos+dPos+6*abstand);		
	}
}
