/*
* 14:50:00
* vjanssen
*/
package a0503c_u_Moebel_Teil3;

import java.awt.Color;
import java.awt.Graphics2D;

public class Gefrierschrank extends Moebel
{
	private boolean abtauen;
	
	public Gefrierschrank()
	{
		this(270, 50, Color.WHITE, 50, 90, false);
	}
	
	public Gefrierschrank(int xPos, int yPos, Color farbe, int hoehe, int breite, boolean abtauen)
	{
		super (xPos, yPos, farbe, hoehe, breite);
		if (breite != 50 && breite != 60) this.setBreite(60);
		this.abtauen = abtauen;
	}
	
	public void setAbtauen(boolean abtauen)
	{
		this.abtauen = abtauen;
	}
	
	public boolean getAbtauen()
	{
		return this.abtauen;
	}
	
	public void showObjektVar()
	{
		super.showObjektVar();
		if (this.abtauen) 	System.out.println("-> Taue gerade ab");
		else				System.out.println("-> Normalbetrieb!");
	}

	public void drawObjekt(Graphics2D g)
	{
		super.drawObjekt(g);
				
		int xPos = this.getXPos();
		int yPos = this.getYPos();
		int breite = this.getBreite();
		int hoehe = this.getHoehe();
		Color farbe = this.getFarbe();
		
		int a	= 10;					// Abstand
		
		// Bedienzeile
		g.setColor(farbe);
		g.fillRect(xPos, yPos, breite, a*2);
		g.setColor(Color.GRAY);
		g.drawRect(xPos, yPos, breite, a*2);
		
		// anzeige
		g.fillRect(xPos + a/2, yPos + a/2, a*2, a);
		if (this.abtauen) 	g.setColor(Color.RED);
		else 				g.setColor(Color.GREEN);
		g.fillOval(xPos + a/2 + 3*a, yPos + a/2, a, a);
		g.setColor(Color.GRAY);
		g.drawOval(xPos + a/2 + 3*a, yPos + a/2, a, a);
				
		g.setColor(Color.BLACK);
		g.drawString("Gefrier-", xPos , yPos + hoehe + 2*a);
		g.drawString("schrank", xPos , yPos + hoehe + 3*a);
	}
}
