/*
* 19:03:16
* vjanssen
*/
package a0503d_k_Baum_Teil3;

public class Obstbaum extends Laubbaum
{
	public enum Erntemenge
	{
		WENIG, NORMAL, VIEL
	}
	
	public enum Erntemonat
	{
		JUNI, JULI, AUGUST, SEPTEMBER
	}
	
	private String erntemenge;
	private String erntemonat;
	
	public Obstbaum()
	{
		this(2000, 6.0d, 10.0d, "oval", "gesgt", "Apfel", "NORMAL", "JULI");
	}

	public Obstbaum(int pflanzjahr)
	{
		this(pflanzjahr, 6.0d, 10.0d, "oval", "gesgt", "Apfel", "NORMAL", "JULI");
	}
	
	public Obstbaum(int pflanzjahr, double ausdehnung, double hoehe, String form, String blattform, String frucht, String erntemenge, String erntemonat)
	{
		super(pflanzjahr, ausdehnung, hoehe, form, blattform, frucht);
		this.setErnte(erntemenge, erntemonat);		
	}
	
	
	public boolean setErnte(String erntemenge, String erntemonat)
	{
		boolean ok = false;
		
		for(Erntemenge e : Erntemenge.values())
			if (e.name().equals(erntemenge)) ok = true;
		for(Erntemonat e : Erntemonat.values())
			if (e.name().equals(erntemonat)) ok = true;
		
		if (ok)
		{
			this.erntemenge = erntemenge;
			this.erntemonat = erntemonat;
		}
		else		
		{	// Standardwerte bei Fehleingabe
			this.erntemenge = "WENIG";
			this.erntemonat = "AUGUST";
		}
		
		return ok;
	}
	
	public void setKrank(boolean krank)
	{
		super.setKrank(krank);
		if (krank) this.erntemenge = "WENIG";
	}
	
	public void showObjektVar()
	{
		super.showObjektVar();
		System.out.println("Erntemenge: " + this.erntemenge);
		System.out.println("Erntemonat: " + this.erntemonat);		
	}	
}
