/*
* 10:14:07
* vjanssen
*/
package a0601b_u_Baum_Teil4;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Calendar;
import java.util.GregorianCalendar;

//ACHTUNG! Es muss lediglich das Schlsselwort abstrakt hinzugefgt werden, um die Aufgabe zu erfllen!!!
public abstract class Baum
{
	private int xPos;
	private int yPos;
	private int pflanzjahr;
	private double ausdehnung;		// in m^2
	private double hoehe;			// in m
	private String	form;
	private boolean krank;
	
	public Baum()
	{
		this(100, 100, 2000, 5.0d, 1.0d, "rundlich");
	}
	
	public Baum(int xPos, int yPos, int pflanzjahr)
	{
		this(xPos, yPos, pflanzjahr, 5.0d, 1.0d, "rundlich");
	}
	
	public Baum(int xPos, int yPos, int pflanzjahr, double ausdehnung, double hoehe, String form)
	{
		this.xPos = xPos;
		this.yPos = yPos;
		this.pflanzjahr = pflanzjahr;
		this.ausdehnung = ausdehnung;
		this.setHoehe(hoehe);
		this.form = form;
		this.krank = false;
	}
	
	public int alter()
	{
		Calendar cal = new GregorianCalendar();
		int jahr = cal.get(Calendar.YEAR);
		
		return jahr - this.pflanzjahr;
	}
	
	public void setKrank (boolean krank)
	{
		this.krank = krank;
	}
	
	public boolean getKrank()
	{
		return this.krank;
	}
	
	public void setHoehe(double hoehe)
	{
		if (hoehe < 1.0d)	this.hoehe =  1.0d;
		else				this.hoehe = hoehe;
	}
	
	public double getHoehe()
	{
		return this.hoehe;
	}
	
	public int getXPos()
	{
		return this.xPos;
	}
	
	public int getYPos()
	{
		return this.yPos;
	}
	
	public void setAusdehnung(double ausdehnung)
	{
		this.ausdehnung = ausdehnung;
	}
	
	public double getAusdehnung()
	{
		return this.ausdehnung;
	}
	
	public void showObjektVar()
	{
		System.out.println("----- Baum -----");
		System.out.println("Planzjahr:  " + this.pflanzjahr);
		System.out.println("Alter:      " + this.alter());
		System.out.println("Ausdehnung: " + this.ausdehnung);
		System.out.println("Hoehe:      " + this.hoehe);
		System.out.println("Form:       " + this.form);
		if (this.krank)	System.out.println("-> Krank");
		else			System.out.println("-> Gesund");
	}
	
	public void drawObjekt(Graphics2D g)
	{
		int bPos = 15;				// Standardeinheit fr Breite und Hhe
		
		int ebenen = (int) this.hoehe;
		if (ebenen < 0) 	ebenen = 0;
		if (ebenen > 10) 	ebenen = 10;
		
		// Koordinatenkorrektur fr Anwachsende Bume (Zusatzaufgabe)
		int xPos = this.xPos + (ebenen+1) * bPos;
		int yPos = this.yPos - 2 * bPos;
		
		// Stamm ermitteln (Zusatzaufgabe)
		int b = bPos * (ebenen-1) +2;
		int h = bPos * 2+b;
		int x = xPos - b / 2 -1; 		// Automatischer Typcast
		int y = yPos + (ebenen+1) * bPos *2-b;
					
		// Stamm zeichnen
		g.setColor(Color.ORANGE);
		g.fillRect(x, y, b, h);
	}
}
