/*
* 14:25:54
* vjanssen
*/
package a0602c_k_Patient_Teil8_abstrakteKlasse;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class Patient extends AbsName implements InterAnzeige
{
	private char geschlecht;
	private int geburtsjahr;
	private double groesse;
	private double gewicht;
	private boolean krank;
	
	private Arzt hausArzt;
	
	public Patient()
	{
		this ("Eva", "Klein", 'w', 2001, 1.55d, 53.0d, false, null);
	}
	
	public Patient(String vorname, String nachname, char geschlecht, int geburtsjahr, double groesse, double gewicht, boolean krank, Arzt hausArzt)
	{
		super(vorname, nachname);
		this.geschlecht = geschlecht;
		this.geburtsjahr = geburtsjahr;
		this.groesse = groesse;
		this.gewicht = gewicht;
		this.krank = krank;
		this.hausArzt = hausArzt;
	}
	
	public void erstUntersuchung()
	{
		if (this.hausArzt != null)
		{
			hausArzt.untersucht(this);
		}
	}
	
	public void untersuchung(Arzt arzt)
	{
		arzt.untersucht(this);
	}
	
	public int alter()
	{
		Calendar cal = new GregorianCalendar();
		int jahr = cal.get(Calendar.YEAR);
		
		return jahr - this.geburtsjahr;
	}
	
	public void setGroesse(double groesse)
	{
		this.groesse = groesse;
	}
	
	public void setGewicht(double gewicht)
	{
		this.gewicht = gewicht;
	}
	
	public void setKrank(boolean krank)
	{
		this.krank = krank;
	}
	
	public double getGroesse()
	{
		return this.groesse;
	}
	
	public double getGewicht()
	{
		return this.groesse;
	}

	public boolean getKranke()
	{
		return this.krank;
	}
	
	public void showObjektVar()
	{
		super.showObjektVar();
		System.out.println("Geschlecht:     " + this.geschlecht);
		System.out.println("Geburtsjahr:    " + this.geburtsjahr);
		System.out.println("Alter:          " + this.alter());
		System.out.println("Groesse:        " + this.groesse);
		System.out.println("Gewicht:        " + this.gewicht);
		if (this.krank)	System.out.println("-> Krank");
		else			System.out.println("-> Gesund");
		System.out.println("-> Hausarzt");
		if (this.hausArzt != null) this.hausArzt.showObjektVar();
	}
}
