package a0701a_k_VerketteteListe;

public class Zug<E extends Comparable<E>>
{
	private Wagon<E> lok;
	
	public Zug(E o)
	{
		lok = new Wagon<E>(o);
	}
	
	public void addWagon(E o)
	{
		// Starte bei der Lok
		Wagon<E> w = lok;
		// Erzeuge neuen Wagon
		Wagon<E> neu = new Wagon<E>(o);
		// Erzeuge Referenz-Speicher
		Wagon<E> speicher = lok;
		
		// Einsortieren vor der Lok
		if (neu.kleiner(lok))
		{
			lok = neu;
			neu.setNext(speicher);
		}
		else
		{
			// Gehe die Wogons entlag bis Position oder der Letzte erreicht ist
			while (		w.getNext() != null
					&&	w.kleiner(neu))
			{
				speicher = w;
				w = w.getNext();
			}
			
			// Einsortieren nach dem letzen
			if (w.getNext() == null && w.kleiner(neu))
			{
				w.setNext(neu);
			}
			// Zwischensortieren
			else
			{
				speicher.setNext(neu);
				neu.setNext(w);
			}
		}
	}
	
	public boolean delWagon(int wagonNummer)
	{
		int wagonZaehler = 0;
		
		// Starte bei der Lok
		Wagon<E> w = lok;
		// Erzeuge Referenz-Speicher
		Wagon<E> speicher = lok;
						
		// Gehe die Wogons entlag bis zur angegebenen Wagonnummer
		// oder bis der letzte Wagon erreicht ist
		while (		w.getNext() != null			//es gibt noch einen nachfolger
				&&	wagonZaehler < wagonNummer)	// Wagonnummer wurde noch nicht erreicht
		{
			speicher = w;
			w = w.getNext();
			wagonZaehler = wagonZaehler+1;
		}
		
		if (wagonNummer > wagonZaehler || wagonNummer < 0) return false;
			
		if (wagonZaehler == 0)
		{
			lok = lok.getNext();		// erste Wagon lschen
		}
		else
		{
			if (w.getNext() == null)
			{
				speicher.setNext(null);				// letzten Wagon lschen
			}
			else
			{
				speicher.setNext(w.getNext());		// Zwischenwagon lschen
			}
		}
		
		return true;
	}
	
	public E getInhalt (int wagonNummer)
	{
		// Starte bei der Lok
		Wagon<E> w = lok;
		int wagonZaehler = 0;
				
		// Gehe die Wogons entlag bis zur angegebenen Wagonnummer
		// oder bis der letzte Wagon erreicht ist
		while (		w.getNext() != null			//es gibt noch einen nachfolger
				&&	wagonZaehler < wagonNummer)	// Wagonnummer wurde noch nicht erreicht
		{
			w = w.getNext();
			wagonZaehler = wagonZaehler+1;
		}
		
		// gib den Inhalt des erreichten Wagons zurck
		return w.getInhalt();
	}
	
	private static class Wagon<T extends Comparable<T>>
	{
	// Objektvariablen
		private Wagon<T> next;
		private T inhalt;
		
	// Konstruktoren
		public Wagon (T inhalt)
		{
			this.inhalt = inhalt;
			this.next = null;
		}
		
	// Objektmethoden
		public Wagon<T> getNext()
		{
			return this.next;
		}
		
		public void setNext(Wagon<T> w)
		{
			this.next = w;
		}
		
		public T getInhalt()
		{
			return this.inhalt;
		}
		
		public boolean kleiner(Wagon<T> w)
		{
			if (this.inhalt.compareTo(w.inhalt) < 0) 	return true;
			else										return false;
		}
	}
}
