/*
* 08:51:16
* vjanssen
*/
package a0703a_u_Moebel_Teil4;

import java.awt.Color;
import java.awt.Graphics2D;

public class Moebel  implements StartPos
{	
	public static final String[] MODELLE = {"Hochschrank", "Unterschrank", "Oberschrank"};
	
	private int xPos;
	private int yPos;
	private Color farbe;
	private int breite;		// in cm
	private int hoehe;		// in cm
	private boolean offen;
	private String modell;
	
	public Moebel()
	{
		this(50, 50, Color.WHITE, 50, 90, "Unterschrank");
	}
	
	public Moebel(int xPos, int yPos, int breite, int hoehe)
	{
		this(xPos, yPos, Color.WHITE, breite, hoehe, "Unterschrank");
	}
	
	public Moebel(int xPos, int yPos, Color farbe, int breite, int hoehe, String modell)
	{
		// feste Werte
		this.offen = false;
		// einstellbare Werte
		this.xPos = xPos;
		this.yPos = yPos;
		this.farbe = farbe;
		this.breite = breite;
		this.hoehe = hoehe;
		if (isModell(modell))		this.modell = modell;
		else						this.modell = "Unterschrank";
	}
	
	private boolean isModell(String modell)
	{
		for(String m : MODELLE)
		{
			if (modell.equals(m)) return true;
		}
		return false;
	}

	public String getModell()
	{
		return this.modell;
	}
	
	public int getXPos()
	{
		return this.xPos;
	}
	
	public int getYPos()
	{
		return this.yPos;
	}
	
	public Color getFarbe()
	{
		return this.farbe;
	}
	
	public int getBreite()
	{
		return this.breite;
	}
	
	public int getHoehe()
	{
		return this.hoehe;
	}
	
	public void setOffen(boolean offen)
	{
		this.offen = offen;
	}
	
	public boolean getOffen()
	{
		return this.offen;
	}
	
	protected void setBreite(int breite)
	{
		this.breite = breite;
	}
	
	public void showObjektVar()
	{
		System.out.println("----- Mbel -----");
		//System.out.println("Farbe:  " + this.farbe);
		System.out.println("Breite: " + this.breite);
		System.out.println("Hhe:   " + this.hoehe);
		if (this.offen)	System.out.println("-> offen");
		else			System.out.println("-> zu");
	}
	
	public void drawObjekt(Graphics2D g)
	{
		int a	= 10;					// Abstand
		
		int xPos = this.xPos + X_START;
		int yPos = this.yPos + Y_START;
				
		g.setColor(this.farbe);
		g.fillRect(xPos, yPos, this.breite, this.hoehe);
		g.setColor(Color.BLACK);
		g.drawRect(xPos, yPos, this.breite, this.hoehe);
		
		// Bodenleiste
		g.drawRect(xPos, yPos + this.hoehe - a, this.breite, a);
		
		int b = (int) ((double) this.breite *2.0d/3.0d); // Breite fr geffnete Tr
		if (this.offen)
		{
			g.fillRect(xPos, yPos, b, this.hoehe-a);
			
			// Trgriffe
			g.drawLine(xPos+a/2+b, yPos+3*a, xPos+a/2+b, yPos+5*a);
		}
		else
		{
			// Trgriffe
			g.drawLine(xPos+a, yPos+3*a, xPos+a, yPos+5*a);
		}
	}
}
