/*
* 19:03:16
* vjanssen
*/
package a0703b_u_Baum_Teil5;

import java.awt.Color;
import java.awt.Graphics2D;

public class Obstbaum extends Laubbaum
{
	public enum Erntemenge
	{
		WENIG, NORMAL, VIEL
	}
	
	public enum Erntemonat
	{
		JUNI, JULI, AUGUST, SEPTEMBER
	}
	
	private String erntemenge;
	private String erntemonat;
	
	public Obstbaum()
	{
		this(0, 30, 2000, 10.0d, 4.0d, "oval", "gesgt", "Apfel", "NORMAL", "JULI");
	}

	public Obstbaum(int pflanzjahr)
	{
		this(100, 100, pflanzjahr, 6.0d, 10.0d, "oval", "gesgt", "Apfel", "NORMAL", "JULI");
	}
	
	public Obstbaum(int xPos, int yPos, int pflanzjahr, double ausdehnung, double hoehe, String form, String blattform, String frucht, String erntemenge, String erntemonat)
	{
		super(xPos, yPos, pflanzjahr, ausdehnung, hoehe, form, blattform, frucht);
		this.setErnte(erntemenge, erntemonat);		
	}
	
	
	public boolean setErnte(String erntemenge, String erntemonat)
	{
		boolean ok = false;
		
		for(Erntemenge e : Erntemenge.values())
			if (e.name().equals(erntemenge)) ok = true;
		for(Erntemonat e : Erntemonat.values())
			if (e.name().equals(erntemonat)) ok = true;
		
		if (ok)
		{
			this.erntemenge = erntemenge;
			this.erntemonat = erntemonat;
		}
		else		
		{	// Standardwerte bei Fehleingabe
			this.erntemenge = "WENIG";
			this.erntemonat = "AUGUST";
		}
		
		return ok;
	}
	
	public void setKrank(boolean krank)
	{
		super.setKrank(krank);
		if (krank) this.erntemenge = "WENIG";
	}
	
	public void showObjektVar()
	{
		super.showObjektVar();
		System.out.println("Erntemenge: " + this.erntemenge);
		System.out.println("Erntemonat: " + this.erntemonat);		
	}	
	
	public void drawObjekt(Graphics2D g)
	{
		super.drawObjekt(g);
		
		int bPos = 15;				// Standardeinheit fr Breite und Hhe
		
		int ebenen = (int) this.getHoehe();
		if (ebenen < 0) 	ebenen = 0;
		if (ebenen > 10) 	ebenen = 10;
		
		// Koordinatenkorrektur fr Anwachsende Bume (Zusatzaufgabe)
		int xPos = this.getXPos()+bPos;
		int yPos = this.getYPos() ;
		int breite = ebenen * bPos * 2 ;
		
		// Farbe fr Bltter auf grn stellen
		g.setColor(Color.RED);
		for (int i=0; i<ebenen; i++)
		{
			int x = (int)(Math.random()*(breite/2) + xPos+(breite/4) - bPos/2);
			int y = (int)(Math.random()*(breite/2) + yPos+(breite/4) - bPos/2);
			
			g.fillOval(x, y, bPos, bPos);
		}
	}	
}
